import boto3
import os
import logging
import json
from crhelper import CfnResource
from botocore.exceptions import ClientError

logger = logging.getLogger(__name__)

# Initialise the helper, all inputs are optional
helper = CfnResource(json_logging=False, log_level='DEBUG', boto_level='CRITICAL', sleep_on_delete=120)

@helper.create
def getprefixlists(event, _):
    # Based on: https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/ec2.html#EC2.Client.describe_managed_prefix_lists
    Region = os.environ.get('AWS_REGION')
    client = boto3.client('ec2')
    try:
        response = client.describe_managed_prefix_lists(
            Filters=
            [
                {
                    'Name': 'prefix-list-name',
                    'Values': 
                        [ 
                            "com.amazonaws."+Region+".s3"
                        ]
                },
            ],        
        )
    except ClientError as e:
        if e.response['Error']['Code'] == 'UnauthorizedOperation':
            # Deal with the exception here, and/or rethrow at your discretion.
            raise ValueError("Unauthorized Operation when trying to Describe Managed Prefix Lists - Please check the role associated to the Lambda")
        else:
            raise ValueError("Unknown Error: "+e.response['Error']['Code'])
    logger.debug("Response from API")
    logger.debug(response)
    logger.info("Returning prefixlistid: "+response['PrefixLists'][0]['PrefixListId'])
    logger.info("Returning prefixlistarn: "+response['PrefixLists'][0]['PrefixListArn'])
    helper.Data['prefixlistid'] = response['PrefixLists'][0]['PrefixListId']
    helper.Data['prefixlistarn'] = response['PrefixLists'][0]['PrefixListArn']
@helper.update
@helper.delete
def no_op(_, __):
    pass

def lambda_handler(event, context):
    logger.debug("Cloudformation Event: " + json.dumps(event))
    helper(event, context)