﻿using Amazon;
using Amazon.SQS.Model;
using Amazon.CognitoIdentity;
using Amazon.AspNetCore.Identity.Cognito;
using Amazon.Extensions.CognitoAuthentication;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Samples.Pages
{
    public class MySQSQueuesModel : PageModel
    {
        private readonly CognitoUserManager<CognitoUser> _userManager;
        private readonly IConfiguration _configuration;
        public string Message { get; set; }
        public List<string> SQSUrls { get; private set; }

        public MySQSQueuesModel(UserManager<CognitoUser> userManager, IConfiguration configuration)
        {
            _userManager = userManager as CognitoUserManager<CognitoUser>;
            _configuration = configuration;
        }

        public async Task OnGet()
        {
            Message = "Displaying all SQS Queues.";

            var loggedInUser = await _userManager.FindByIdAsync(User.Identity.Name);
            if (loggedInUser != null)
            {
                CognitoAWSCredentials credentials = new CognitoAWSCredentials(_configuration.GetValue<string>("AWS:IdentityPoolId"), RegionEndpoint.USEast1);
                credentials.AddLogin($"cognito-idp.{_configuration.GetValue<string>("AWS:Region")}.amazonaws.com/{_configuration.GetValue<string>("AWS:UserPoolId")}",
                    loggedInUser.SessionTokens.IdToken);
               
                using (var sqsClient = new Amazon.SQS.AmazonSQSClient(credentials))
                {
                    ListQueuesResponse response =
                        await sqsClient.ListQueuesAsync(new ListQueuesRequest()).ConfigureAwait(false);
                    SQSUrls = new List<string>();
                    foreach (string url in response.QueueUrls)
                    {
                        Console.WriteLine(url);
                        SQSUrls.Add(url);
                    }
                }
            }
        }
    }
}
