﻿using Amazon;
using Amazon.S3;
using Amazon.S3.Model;
using Amazon.CognitoIdentity;
using Amazon.AspNetCore.Identity.Cognito;
using Amazon.Extensions.CognitoAuthentication;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Samples.Pages
{
    public class MyS3Buckets : PageModel
    {
        private readonly CognitoUserManager<CognitoUser> _userManager;
        private readonly IConfiguration _configuration;
        public string Message { get; set; }
        public List<string> Buckets { get; private set; }

        public MyS3Buckets(UserManager<CognitoUser> userManager, IConfiguration configuration)
        {
            _userManager = userManager as CognitoUserManager<CognitoUser>;
            _configuration = configuration;
        }

        public async Task OnGet()
        {
            Message = "Displaying all S3 Buckets.";

            /* Authenticated Approach */

            //a. Retrieve access token for logged in user.            
            var loggedInUser = await _userManager.FindByIdAsync(User.Identity.Name);            
            if (loggedInUser != null)
            {
                var providerName = $"cognito-idp.{_configuration.GetValue<string>("AWS:Region")}.amazonaws.com/{_configuration.GetValue<string>("AWS:UserPoolId")}";

                //b. Exchange access token for AWS credentials
                CognitoAWSCredentials credentials = new CognitoAWSCredentials(_configuration.GetValue<string>("AWS:IdentityPoolId"), RegionEndpoint.USEast1);
                credentials.AddLogin(providerName,
                    loggedInUser.SessionTokens.IdToken);

                //c. Access S3 service with AWS credentials
                using (var client = new AmazonS3Client(credentials))
                {
                    ListBucketsResponse response =
                        await client.ListBucketsAsync(new ListBucketsRequest()).ConfigureAwait(false);
                    Buckets = new List<string>();
                    foreach (S3Bucket bucket in response.Buckets)
                    {
                        Console.WriteLine(bucket.BucketName);
                        Buckets.Add(bucket.BucketName);
                    }
                }                
            }            
        }
    }
}
