from opencv_pano import OpenCVApp
import cv2
import time

# MY_RTSP_STREAM = "rtsp://system:system1234@192.168.0.106:554/cam/realmonitor?channel=1&subtype=0"
# MY_RTSP_STREAM = "rtsp://system:system1234@192.168.0.106:554/cam/realmonitor?channel=1&subtype=1"
MY_RTSP_STREAM = "rtsp://192.168.1.135:8554/stream1"

class MyApp(OpenCVApp):

    def process_frames(self):
        print("Processing frames, press ESC to exit.")
        frame_count = 0
        start_time = time.time()
        while True:
            frame = self.video_in.get()
            frame_count = frame_count + 1

            cv2.imshow("OpenCV", frame)

            key = cv2.waitKey(5)   #wait for a keyboard input
            if key == 27:
                end_time = time.time()
                break

        time_in_sec = (end_time - start_time)
        print(f"Processed {frame_count} frames in {time_in_sec:.2f} seconds or {frame_count/time_in_sec:.2f} frames per second.")


    

my_app = MyApp(MY_RTSP_STREAM)

my_app.process_frames()
