    function Invoke-ExternalCommand {
    <#
    .SYNOPSIS
    Helper function for invoking an external command.
    .DESCRIPTION
    The reason for this function is to allow calls to external commands
    .EXAMPLE
    Invoke-External $LiteralPath $PassThruArgs

    Description
    -----------
    The reason for this function is to allow calls to external commands
    #>

    [CmdletBinding()]

    Param
    (
        [Parameter(HelpMessage = 'Path for the external command')]
        $LiteralPath,

        [Parameter(ValueFromRemainingArguments=$true)]
        $PassThruArgs
    )

    & $LiteralPath $PassThruArgs
}