import subprocess
from os import environ
 
from pre_wigs_validation.enums import ValidationEnforcement, ValidationResult
from pre_wigs_validation.instance import ValidationInstance
from pre_wigs_validation.dataclasses import ValidationOutput
from pre_wigs_validation.utils import check_validation_config
 
 
class HttpProxyConfiguration:
     """Validate custom http/https proxy is not configured"""
 
     validation = "PROXY Configuration"
     enforcement = ValidationEnforcement.RECOMMENDED
 
 
 
     @classmethod
     def validate(
         cls, *, enabled: bool = True, instance: ValidationInstance
     ) -> ValidationOutput:
 
         """
         Parameters:
         enabled (bool): whether or not to run this validation function
         instance (ValidationInstance): the instance object being validated
 
         Returns:
         ValidationOutput: output of validation
         """
 
         if not enabled:
             return ValidationOutput(
                 validation=cls.validation,
                 result=ValidationResult.NOT_RUN,
                 enforcement=cls.enforcement,
             )
 
         fail_message = "A http/https proxy is configured, might impact the WIGs "
 
 
         config = check_validation_config(
             default_params=cls.validate.__kwdefaults__, local_params=locals()
         )
 
         proxy_good = True
 
         try:
           if environ.get('http_proxy') or environ.get('https_proxy'):
              proxy_good = False 
 
         except Exception as error:
             fail_message += str(error)
 
         if proxy_good:
             return ValidationOutput(
                 validation=cls.validation,
                 result=ValidationResult.PASS,
                 enforcement=cls.enforcement,
                 config=config,
             )
 
         return ValidationOutput(
             validation=cls.validation,
             result=ValidationResult.FAIL,
             enforcement=cls.enforcement,
             config=config,
             message=fail_message,
         )

