import os
import sys
import distro
import subprocess
from pre_wigs_validation.enums import ValidationEnforcement, ValidationResult
from pre_wigs_validation.instance import ValidationInstance
from pre_wigs_validation.dataclasses import ValidationOutput
from pre_wigs_validation.utils import check_validation_config
 
class RHPythonCheck:
     """Validate rh-python36 package availability for RHEL OS distribution"""
 
     validation = "RHPython36 availability"
     enforcement = ValidationEnforcement.RECOMMENDED
 
     @classmethod
     def validate(
         cls, *, enabled: bool = True, instance: ValidationInstance
     ) -> ValidationOutput:
 
         """
         Parameters:
         enabled (bool): whether or not to run this validation function
         instance (ValidationInstance): the instance object being validated
 
         Returns:
         ValidationOutput: output of validation
         """
 
         if not enabled:
             return ValidationOutput(
                 validation=cls.validation,
                 result=ValidationResult.NOT_RUN,
                 enforcement=cls.enforcement,
             )
 
         config = check_validation_config(
             default_params=cls.validate.__kwdefaults__, local_params=locals()
         )
 
 
         """
         Parameters:
         No parameters, function checks the availability of rh-python36 package in case the OS is rhel
 
         Returns:
         ValidationOutput: output of validation
         """
         fail_message = "The rh-python36 package is not listable, please enable required repo for the same"
 
         distribution = distro.id()
         major_version = distro.major_version()
         supported_major_versions = [ "6" , "7" ]
         if distribution == 'rhel' and  major_version in supported_major_versions:
            repo_check_command = ["yum", "list","rh-python36"]
            proc = subprocess.run(
                repo_check_command,
                stdout=subprocess.DEVNULL,
                stderr=subprocess.PIPE,
            )
            if proc.returncode !=0:
                  verbose_message = proc.stderr.decode("utf-8")
                  return ValidationOutput(
                         validation=cls.validation,
                         result=ValidationResult.FAIL,
                         enforcement=cls.enforcement,
                         config=config,
                         message=fail_message,
                         verbose_message=verbose_message,
                        )
         return ValidationOutput(
                validation=cls.validation,
                result=ValidationResult.PASS,
                enforcement=cls.enforcement,
                config=config,
                )
