import os
import sys
import subprocess

from pre_wigs_validation.enums import ValidationEnforcement, ValidationResult
from pre_wigs_validation.instance import ValidationInstance
from pre_wigs_validation.dataclasses import ValidationOutput
from pre_wigs_validation.utils import check_validation_config
 

class CustomDHClientConfigCheck:
     """Validate dhclient configuration does not exist. Custom dhclient configuration may cause launch failure of post wigs instance"""
 
     validation = "dhclient Configuration File"
     enforcement = ValidationEnforcement.RECOMMENDED
 
     @classmethod
     def validate(
         cls, *, enabled: bool = True, instance: ValidationInstance
     ) -> ValidationOutput:
 
         """
         Parameters:
         enabled (bool): whether or not to run this validation function
         instance (ValidationInstance): the instance object being validated
 
         Returns:
         ValidationOutput: output of validation
         """
 
         if not enabled:
             return ValidationOutput(
                 validation=cls.validation,
                 result=ValidationResult.NOT_RUN,
                 enforcement=cls.enforcement,
             )
 
         config = check_validation_config(
             default_params=cls.validate.__kwdefaults__, local_params=locals()
         )
 
 
         """
         Parameters:
         No parameters, function checks whether a dhclient configuration exists 
 
         Returns:
         ValidationOutput: output of validation
         """
         fail_message = "A /etc/dhclient-eth0 config exist,it can cause postwigs failure"
         dhclient_file = "/etc/dhclient-eth0.conf"
         custom_file_exists = os.path.exists(dhclient_file)
         if custom_file_exists:
            return ValidationOutput(
                 validation=cls.validation,
                 result=ValidationResult.FAIL,
                 enforcement=cls.enforcement,
                 config=config,
                 message=fail_message,
                 )
         return ValidationOutput(
                validation=cls.validation,
                result=ValidationResult.PASS,
                enforcement=cls.enforcement,
                config=config,
                )
