# Token Vending Machine Sample App
This code is provided as part of the Amazon Prescriptive Guidance pattern "Implementing SaaS Tenant Isolation for S3 using an AWS Lambda Token Vending Machine". The code in this pattern can be used as a basis to implement a SaaS application that generates scoped temporary STS credentials based on the claims provided in a JWT token.


## Prerequisites
This sample is written in Java. You will need a properly configured OpenJDK 11.x and Maven 3.x installation to compile the code in this project. It is recommended to use the [Amazon Corretto 11](https://docs.aws.amazon.com/corretto/latest/corretto-11-ug/what-is-corretto-11.html) as your JDK, as this is the version that is recommended for as an AWS Lambda runtime.

Additionally, the JARs created by compiling the code in this project are intended to be run on AWS Lambda. They have not been tested in other environments. Detailed instructions for deploying the compiled artifacts from this code can be found in the Amazon Prescriptive Guidance pattern "Implementing SaaS Tenant Isolation for S3 using an AWS Lambda Token Vending Machine".

## Compiling the Code
To compile the code contained in this project, execute the following command from the root of the project:
```
mvn clean package
```
This command will produce two JARs, which can be found in `/s3UploadSample/target` and `/tokenVendingLayer/target` relative to the root of the project.