(CNN) -- European football's summer months are dominated by back-page headlines of glamorous transfers involving the game's most prestigious players, with Arsenal's Robin van Persie the most notable example this last few weeks as he ponders whether to stay with the London club after saying he will not renew his contract.

But at the bottom of the football pyramid -- a world that receives little attention from the global media -- there are many deals that involve young players who are just starting their careers, the clubs that have trained them, and those that are interested in signing them in the hope that they might be the next Lionel Messi.

The story of Messi's early years in Argentina and his signing by Barcelona has been retold countless times. Of how, diagnosed with a growth hormone deficiency, the kid who would become the world's best player went to Spain after Barcelona offered to pay his medical bills.

What is less well known is that Barcelona did not immediately pay his former club Newell's Old Boys the training compensation fee that the Argentine team was due.

Can PSG's big bucks buy world domination?

Newell's Old Boys did claim $42,867 in reparation, but had to go all the way to FIFA's Dispute Resolution Chamber to get the payment.

It takes time and money for clubs to develop players, but the rewards can be enormous given the voracious appetite of ambitious teams looking for new talent.

But this talent trawl leaves casualties and an academic study in 2009 estimated as many as 20,000 African boys are living in the streets of Europe after failing to secure contracts with European clubs following their trials.

Under rules established by football's international governing body FIFA, those clubs seeking that new talent agree to pay the team that nurtured the youngster a "training compensation" fee.

FIFA has a cash formula that is designed to compensate the "training club" for the years spent developing players up to the age of 23, when they sign their first professional contract.

However, sports agent Paulo Teixeira says some European teams do not always play ball in agreeing these compensation fees.

Teixeira, who has worked as a player agent and once represented former Brazil international Roberto Carlos, has taken to posting about training compensation on Facebook., pointing to the way social media was used during the Arab Spring as a motivation in raising publicity over the issue.

"It's a matter of culture," Teixeira writes on Facebook, recounting what he says he was told by an executive of a European team ahead of the Champions League final in Munich back in May.

"European clubs are ready to pay millions on transfer fees, but when it comes to settling training compensation to African or South Americans clubs, it becomes a problem.

"Clubs know that they will have to pay once the cases reach FIFA, but until then they buy time."

The Brazilian agent is football's equivalent of a bounty hunter, taking a hefty commission from the teams he represents in cases he takes before FIFA to claim training compensation from larger clubs.

Teixeira details his disputes with a number of those European clubs on Facebook, claiming they failed to pay the true cost of training a player to the development club, based on FIFA's formula.

Unhappy about these Facebook postings, at least two of those clubs -- Italy's AC Milan and Anderlecht of Belgium -- have complained to FIFA about what they claim is "defamation and calumny".

"FIFA can confirm that AC Milan and Anderlecht have lodged complaints against the agent Paulo Teixeira and that FIFA has opened a case," FIFA told CNN.

"However, as the investigations are currently ongoing we cannot comment or speculate at this stage."

But as well referencing the Arab Spring, Teixeira quotes the Universal Declaration of Human Rights -- "everyone has the right to freedom of opinion and expression" -- as justification for his campaign.

In one of the cases Teixeira posts about, he claims AC Milan owes Botafogo FC of Ribeirao Preto compensation involving its training of the player Sergio Ceregatti.

He says the claim is based on the calculation that Ceregatti was with the Brazilian club for four years before moving to Italy.

Ceregatti initially joined Ancona and then signed for Milan, with Botafogo not compensated for those formative years of training as per FIFA's rules.

"At this stage, I just can tell you that the player gave three different declarations (one of them signed by his father, when Ceregatti was still a minor) about the duration of his registration to Botafogo -- nine months; 24 months; 48 months circa," said Leandro Cantamessa, the lawyer acting for AC Milan.

"AC Milan immediately paid on May 2011 the amount requested by Teixeira pursuant to the first player's declaration and moreover in conformity with Botafogo's records, as collected by Brazilian Federation (CBF) in the so-called sport passport, duly attached to the first Teixeira claim.

"The last declaration has been released by Ceregatti in Brazil, in January 2012, after his escape from Italy and from contractual obligations with AC Milan."

Texeira tells a very different story, insisting he has full the support of Ceregatti, who recently returned to Brazil after signing with Vasco da Gama, and that the Brazilian footballer confirms he had been at Botafogo for four years since the age of 12 from 2004.

The gambling game: Soccer's battle with betting

"The claim is for Botafogo and has nothing to do with Ceregatti," added Teixeira, after CNN asked to interview the player.

As for Anderlecht, general manager Hermann van Holsbeeck refused to comment on Teixeira's $122,822 compensation claim on behalf of DR Congo club CS Aigles Verts relating to one of their players, but added: "We have introduced a file against Teixeira by FIFA. We will defend our position at the court."

Teixeira works closely with the Brazilian National Amateur League manager Jose Tobaldini, who keeps track of 140,000 players on a computer database and believes hundreds of young players literally "disappear" from their clubs -- lured away by agents and scouts.

"I know they've all gone to Europe, most of them have the possibility of acquiring dual citizenship," says Tobaldini.

Teixeira claims on Facebook that "a generation of dozens of young Brazilian and African players were literally taken away from their original clubs by dubious agents and brought to Italy under the so-called primo tesseramento (first contract)."

Often smaller clubs in Brazil and Africa do not have the financial resources to find out what has happened to their players after they have left, presumably for Europe -- which means they are often left without compensation. That is where Teixeira steps in.

After a player has turned professional, Teixeira -- with the help of Tobaldini -- tracks down the development club to see if there are compensation issues and then begins the administrative process of demanding what he says is the correct sum to be paid by the European clubs.

"In the beginning I was approaching the clubs, but now more and more I am approached by clubs," said Teixeira. "All due to the internet, as you can imagine. Some African agents have sent me messages saying I've become an icon."

In an arrangement that is reminiscent of the kind of fees "uplift" that successful personal injury lawyers use to get paid if and when a dispute is resolved, Teixeria would receive a 20% commission of the amount of the claim.

So in the cases he lists on Facebook, the potential compensation amount is close to $2.4 million, which would net Teixeira approximately $480,000 if he is successful.

"Big clubs are always challenging the conformity of training compensation with EU law," said Argentine lawyer Ariel Reck, who also has experience with of this area and it is a view supported by British lawyer Guy Thomas.

"The Jean-Marc Bosman case may have increased player power," said Thomas, referring to the landmark judgment allowing players to move for free at the end of their contract, "but ongoing uncertainty over the best way to calculate compensation still allows clubs the chance to push back or delay payment."

Blog: Time to get tough on racism in football

Reck admits these cases are a gravy train for agents and lawyers.

"This is also a business for sports lawyers, I have to confess. Not only South American but also big European firms (mostly Spanish due to language issues) offer clubs the services to claim and collect such compensations. Fees can be as high as 30% of the amount," he said.

Gravy train or not, this issue may also be an administrative headache for FIFA, which says it receives 3,500 complaints a year -- though not all of these relate to training compensation cases.

"FIFA's normal procedure says that a case should be opened within three to five weeks after the claim is lodged," said lawyer Fernando Lamar, who works with Teixeira.

"FIFA says that an ordinary case would take six to 12 months to be solved. However, we have cases in progress for almost two years and we're not halfway through.

"You cannot imagine the time and energy spent trying to reach a FIFA officer to have information about the claims. It is almost a lost battle; the most common responses we get are, 'We are overloaded,' 'We have no time.' "

In a statement to CNN, FIFA said: "Cases are normally opened within a couple of weeks following the receipt of the relevant complaint.

"As to the duration of a specific procedure, we need to emphasize that many factors influence the advancement of the investigation phase and the decision-making process: the cooperation of the parties, the complexity of the matter, the extent of the documentation provided, the availability of the deciding body -- just to name a few.

"Consequently, we are really not in a position to comment on an estimated timescale ."

In a recent edition of the Sports Law Bulletin, a doctoral researcher at England's University of Westminster came up with an idea to help protect the treatment of minors in football.

"A possible solution to prevent such circumstances could be introduction of a form of authorization for trials via the transfer matching system, albeit trials cannot be deemed as a transfer, " wrote Serhat Yilmaz, referring to FIFA's governing body electronic method of conducting transfers.

So as the lawyers, agents and administrators argue, does Tobaldini have any advice for parents considering letting their offspring move to European clubs?

"First you should build the athlete up, maintain his focus on school and look for an agent -- properly accredited -- with the goal of taking care of his professional career."



Agent seeks compensation for clubs who lose young players to bigger teams



Paulo Teixeira says some European sides do not always play ball in agreeing fees



Two European clubs have complained to FIFA about Brazilian agent's claims



Teixeira typically gets 20% of any compensation payment that is made