London (CNN) -- Two iconic teams, each boasting a history and tradition that spans generations, will go head-to-head for club football's biggest prize on Saturday.

Manchester United, the champions of England, face Barcelona, the champions of Spain, at London's famous Wembley Stadium for the right to be crowned Europe's best.

These are teams whose exploits inspire emotions and evoke memories that are embedded in the psyche of fans all over the globe.

But who will triumph in the UEFA Champions League final -- the culmination of a competition that began with qualifying rounds in June last year -- when the two titans clash in front of 86,000 avid supporters and millions more watching around the world?

Will it be United, the home of the Busby Babes, George Best and David Beckham -- or Barca, where football legends Diego Maradona, Johan Cruyff and Lionel Messi are revered?

Pinto's picks: The European season in hindsight

CNN gives you the lowdown on why this match is so special, and why so many neutrals will be tuning in to watch the outcome.

UEFA's dream final

Spain's Primera Liga and England's Premier League are regarded as the two best leagues in European football. However, only once in 55 previous finals have both countries' respective champions faced each other.

Manchester United and Barcelona were also the finalists on that occasion two years ago in Rome, with the Spanish side running out 2-0 winners.

And with only German champions Borussia Dortmund sandwiched between Barcelona (79,000) and Manchester United (75,000) in Europe's average home attendance table, it means demand for final tickets is almost unprecedented.

With each club receiving just 25,000 tickets apiece, at prices ranging from $490 for the most expensive to $245 for the cheapest, never before will so many fans be watching from the comfort of their TV screens.

UEFA spokesman Kimmo Bellmann told CNN: "We expect viewing figures to be in excess of 300 million, which will make it the biggest final in the history of the European Champions League.

"The match will be aired in 220 territories by 113 broadcasters, while there will be 180 cameras covering the action, of which 38 will be in high definition."

UEFA has been accused of pricing fans out of attending the match, but the reality is that the ruling body could fill Wembley three times over because of the support that both teams generate.

Financial fortune

A report commissioned by sponsors MasterCard predicts that the winners of the final will enjoy a record economic windfall of around $180 million.

The figure is based on a  combination of official prize money, an increase in squad value, enhanced media rights and greater brand equity.

Even the losers will receive in the region of $105 million for their efforts.

Professor Simon Chadwick, author of the report, said: "Manchester United versus Barcelona is the dream final as far as most football fans are concerned.

"But the English and Spanish champions are two of the most successful teams off the pitch too. They will collectively scoop $285 million, making this the most lucrative final in European club football's history."

Chadwick added: "Forbes magazine last year listed Manchester United as the most valuable sports brand on the planet, while Barcelona claimed eighth spot in the league table.

"While the Champions League is a strong brand in its own right, the nature and strength of the brand is clearly heavily influenced by its constituent parts -- the participating clubs."

Battle of the giants

Alongside Real Madrid, Barcelona and Manchester United are the two biggest clubs in European soccer -- with a tradition for playing the game with style and panache.

Such is their popularity, they attract fans from all over the world, not just the Catalan region of Spain or the north-west of England.

Barcelona have more than 1,300 officially registered supporters' clubs globally, with estimates that 25% of the Spanish population follows Barca.

Meanwhile, United have long been recognized as the most supported football team in the world.

The club's official Facebook page became the fastest growing of any sports side in the world, registering almost 2.4 million followers within two months of being set up in July 2010.

Accountancy firm Deloitte recently estimated United had 75 million fans worldwide, although other estimates have the figure at a mind-blowing 300 million -- largely based on huge income streams from Asia, where the club has a massive following.

United officially recognize over 200 supporters clubs in 24 countries, with huge swathes of support coming from the south of England, many miles from the club's Lancashire roots.

The 22 players

Not every soccer fan supports Barcelona or Manchester United, but nearly every follower will be monitoring proceedings on television, radio or the Internet.

As well as attracting worldwide support, there will be millions of fans willing either of the teams to lose -- especially in Madrid and Liverpool, where the bitter rivals of both clubs are based.

For those neutrals just wanting to watch a game of soccer, a treat could well be in store.

Busquets free for Champions League final

This current Barcelona side is being widely touted as the greatest to ever grace club football. Packed to the brim with players who helped Spain win the 2008 European Championship and 2010 World Cup final, they also have the best player in the world among their ranks.

Argentina forward Messi is blessed with remarkable skill, balance and control and the 23-year-old is following in the footsteps of both Dutchman Cruyff and compatriot Maradona in starring for Barca while being universally recognized as the number one player on the planet.

Add to the list the attacking talents of David Villa, Xavi Hernandez, Andres Iniesta and Dani Alves, as well as the defensive steel of Carlos Puyol and Gerard Pique -- the only player on view who has played for both teams after starting his senior career at United before returning to the Camp Nou -- then it's easy to see why the Spanish side are favored to win the match.

Under coach Pep Guardiola, already a Catalan hero for his time as player with the club, Barca have won three Spanish league titles in a row and are on the verge of a second Champions League title in that period -- a remarkable record.

United come into the game on the back of sealing a record 19th domestic league title, a significant achievement as it moved them clear of rivals Liverpool.

They boast the greatest English player of his generation, striker Wayne Rooney, and golden oldies Ryan Giggs (37) and goalkeeper Edwin van der Sar (40) -- the latter will be retiring at the end of the match.

Why Scottish coaches rule English football

But perhaps United's main hope of halting Barca lies with manager Alex Ferguson, who can lay claim to being the greatest coach in soccer history.

In his 25 years in charge of the club, Ferguson has won 12 league titles and countless other domestic trophies. If he leads United to victory on Saturday, he will become the first manager to win three Champions League titles.

Battle for supremacy

The original European Cup was initiated in 1955 by French newspaper L'Equipe, under the jurisdiction of UEFA.

Although the eventual premise was to involve only teams who had won their domestic league titles, in the early days L'Equipe actually invited those teams it considered to have the most fan appeal to participate.

Barcelona's Spanish rivals Real Madrid dominated in its formative years, taking the trophy in the first five years, while English clubs dominated from 1976 to 1982, winning six times in a row courtesy of Liverpool, Nottingham Forest and Aston Villa.

The format remained the same until 1992, when UEFA created the Champions League, involving not only domestic champions but also teams who finished second, third and fourth in their respective leagues.

United and Barca both won the competition once under the old format (United in 1968 and Barca in 1992 -- ironically both times also at Wembley).

And, since the introduction of the Champions League, the two teams have maintained identical records, both winning the cup twice and losing in the final once.

Saturday's match will see one of the teams claim their fourth European title, overtaking the beaten finalist in the all-time winners' table.

The wonder of Wembley

To much national debate, Wembley Stadium, the recognized home of soccer in England -- the country where the sport originated -- was closed in 2000, ahead of a controversial proposal to raze it to the ground before building a new arena on the same site.

Football cathedral prepares for final

The stadium's dramatic opening in 1923 set the trend for 77 years of iconic images.

That year, an estimated crowd of over 200,000 piled in to the newly-built arena to watch the FA Cup final between Bolton and West Ham, spilling onto the pitch numerous times only to be dispersed by a policeman on a white horse.

That initial "White Horse Final" proved the prelude for a lifetime of sporting and non-sporting memories that gives Wembley its legendary status.

From local hero Henry Cooper knocking down the greatest heavyweight boxer of them all (Cassius Clay in 1963 before he changed his name to Muhammad Ali) to England captain Bobby Moore wiping his muddy hands before accepting the 1966 World Cup trophy from Queen Elizabeth II, Wembley Stadium has been at the forefront of English folklore.

But perhaps the most famous date in the stadium's history fell on July 13, 1985, when 72,000 music fans attended Live Aid, a 10-hour concert to raise funds for famine relief in Ethiopia which featured some of the biggest names in British music history coming together on an emotional and unforgettable balmy evening.

When the new $1.3 billion Wembley Stadium finally opened its doors in 2007, following various legal disputes between its constructors and the English Football Association, seven long years had passed.

Now, four years later, the famous stadium will stage its biggest match since being rebuilt.



Manchester United will face Barcelona in the Champions League final at Wembley



Both teams are aiming to become European champions for the fourth time



The final is a repeat of the 2009 final in Rome, when Barcelona triumphed 2-0



UEFA expects viewing figures of over 300 million people worldwide