(CNN) -- The Ashes is not a sporting event -- it is an obsession.

Since 1882, England and Australia's cricketers have fought, wrestled and spilled blood in one of the world's fiercest rivalries.

Whether it be on the rugby field or on the cricket pitch, these two countries only care about one thing -- winning.

On Wednesday, when England and Australia go head to head in cricket's biggest contest, the Ashes, two countries will hold their collective breath and prepare for a brutal battle.

It seems perverse that a game, which pauses for tea, and has the possibility of not having a winner after a five day contest, can stir such fierce emotion.

But for these two countries, thousands of miles apart, the yearning for victory could not be greater.

Rivalry

It's a rivalry which encompasses everything good, and sometimes bad, about sport.

It's about pride. It's about passion. It's about blood, guts, victory at all costs.

But it's also about respect, a love of the game and the realization that these two nations are forever intertwined through one of sports greatest and most dynamic rivalries.

Then there's the history.

There's Captain James Cook discovering Australia in 1770 and the settling of British prisoners in Australia 18 years later.

Add to that the brotherhood and bond between the two countries in time of war and the union of the Commonwealth.

And why not throw a shared monarch into the mix too?

United by history, divided by sport. It's one rivalry which threatens to remain eternal.

So when when the players of England and Australia walk out at Trent Bridge, with the words of William Blake's Jerusalem ringing in their ears, they will know that the battle has begun.

The CNN Ashes guide

To understand the birth of this great rivalry requires a glance at the past.

After enduring a dismal defeat by Australia on home soil at The Oval in August 1882, English cricket was left in a state of shock and embarrassment.

A newspaper, the Sporting Times, carried a satirical obituary of English cricket, which stated that: "The body will be cremated and the ashes taken back to Australia."

When England traveled to Australia for the return series, it gained revenge with captain Ivo Bligh awarded a small terracotta urn to symbolize the winning of the Ashes.

That small urn is arguably the most precious prize in world cricket with Australia holding it on 31 occasions to England's 30.

Controversy

There has been no shortage of drama during Ashes encounters -- but some are better remembered than others, although not always for the right reasons.

The most controversial Ashes series remains that of 1932-33, which was known as "Bodyline" after England captain Douglas Jardine ordered his bowlers to bowl straight at the bodies of their opponents.

It was a tactic which caused huge uproar, with Australian batsman Bert Oldfield suffering a fractured skull as England's bowlers showed no mercy.

A 4-1 defeat was difficult to take for Australia and enshrined an extra edge to an already intense rivalry.

Stars

Some of the most famous names in cricket have played in Ashes Test matches -- but there are some which are synonymous with this particular battle.

One of those is Ian Botham, widely regarded as England's biggest Ashes hero having had a Test series named after him.

"Botham's Ashes" which took place in 1981, produced one of the most spectacular moments ever witnessed in an Ashes series.

After resigning as captain just days earlier following an opening Test defeat, England were on the cusp of going 2-0 down in the series.

A dismal start to the second Test at Headingley left Australia tantalizingly close to victory -- but Botham's heroics defied all the odds.

An unbeaten 149 from 148 deliveries gave England hope, forcing Australia to score 130 to win the match.

But the tourists only managed 111 -- handing the victory to England, which eventually went on to win the series.

Australia dominated between 1989 and 2003 -- winning eight consecutive series.

The undisputed team of the decade in the 1990s and early 2000s, Australia boasted several world class players such as Shane Warne, Glenn McGrath, Ricky Ponting and brothers Steve and Mark Waugh.

Then there was wicketkeeper Adam Gilchrist, who scored the second fastest century in Test match cricket during Australia's 5-0 whitewash of England in 2006-7.

But Australia's and indeed the world's greatest ever batsman, is widely acknowledged to have been Donald Bradman.

'The Don' scored 5,028 runs in Ashes contests during his career from 1928-1948 and finished with an average of 99.94.

Australia have also dominated with the ball with Warne the leading wicket taker in Ashes cricket with 195, while McGrath claimed an impressive 157.

Recent history

While, England might be favorites to win this series, it's important to realize it wasn't always this way.

When the 2005 series came to England, Australia was hoping to win its ninth consecutive Ashes series.

A routine victory in the opening Test appeared to confirm its status as favorite before a narrow two-run defeat at Edgbaston drew England level.

A crucial England victory at Trent Bridge in the fourth Test, coming in between two drawn games, gave the host nation its first series win since 1989.

It was the series which introduced Kevin Pietersen to the world stage and led to Andrew Flintoff establishing himself as favorite with cricket fans across the world.

Flintoff's 24 wickets and 402 runs were integral to England's success

But his next venture did not go so smoothly as he captained England during its tortuous 5-0 whitewash defeat in Australia in 2006/7.

That result left a huge scar on English cricket as Australia humiliated its rival in ruthless fashion.

But England bounced back in 2009, winning the home series, before achieving its first victory on Australian soil in 24 years following a 3-1 win in 2010-11.

The players

For the players of both teams, playing in the Ashes is the pinnacle. It means everything.

There is no greater honor for an English or Australian cricketer -- the stakes are at their highest and victory ensures sporting immortality.

But where there are great gains to be made, there are also great losses which can be suffered.

And while Australia may not be at its strongest, England is not taking anything for granted.

"It's a bit of a dream come true starting an Ashes series at home in front of all your family and friends at Trent Bridge," said England bowler Stuart Broad, who plays for Nottinghamshire.

"But it's all about winning, because if you lose, you look back at that match with horrible memories. But if you win, you have very fond memories, so it's an advantage for us as a team.

"You know what Australians are like. They are tough characters who love to win and you would be disappointed if they didn't come out with a lot of fight.

"You'd be disappointed if there wasn't fire in their bellies in an Ashes series anyway."

Australia might start the series as underdogs but its captain, Michael Clarke, is confident his players can provide a shock result.

"I know especially back in Australia, this is the pinnacle of an Australian cricketer, to play Test cricket in England, be part of an Ashes series and I'm sure there will be judgments made on our performances, and as captain of the team you should be accountable," said Clarke.

"I've said for a while now that we come here as underdogs but that hasn't affected our preparation and it won't affect our performance either.

"We know it's going to be tough but I know our boys are up to the challenge.

The fans

England's cricket team enjoys unparallelled support in international cricket with is fans universally known as "The Barmy Army".

Created in 1994 by three friends, the "Army" now boasts over 5,000 members and arranges tours across the world to watch England compete.

Singing, often accompanied by Billy Cooper, a classically trained trumpet player, adds some color, while the chanting can often provide some light entertainment -- unless you're an Australian.

The Barmy Army has a reputation for going after Australia's players with bowler Mitchell Johnson the unfortunate victim during the 2010-11 series.

Australia's fans, known as 'The Fanatics' will be hoping to have something to shout about following two consecutive defeats.

The two sets of supporters groups play a cricket match against each other during every series with England coming up on top this time around.

Where to watch

The five Test matches are taking place throughout England with the opening contest at Trent Bridge, Nottingham.

Following that, the series will move to the Home of Cricket, Lord's, in London, before moving up to Manchester, Durham and back to London.

The English Cricket Board (ECB) has agreed a deal for cricket fans living in mainland Europe and Latin America to watch the series on YouTube.

Star Men

While one captain Cook changed the tide of history in 1770, another is hoping he can make his own mark by putting Australia to the sword.

England captain Alastair Cook enjoyed an outstanding 2010-11 series in Australia, scoring 766 runs. He has more than 7,500 runs to his name and is hoping to win the Ashes for the first time since replacing Andrew Strauss as captain.

The host nation will also be relying on fast bowler James Anderson, who has emerged as one of the most talented players in world cricket. Anderson, who is particularly adept at swinging the ball in either direction, has taken 307 Test wickets in his career -- a number which ranks him joint-third in the all-time list of England bowlers.

For Australia, much depends on the experience of captain Michael Clarke, who has only recently recovered from injury. In his 24 Test matches as captain, he has excelled with the bat at an average of 66.

End game?

England is the favorite to win its third consecutive Ashes series -- a feat which not long ago would have sounded almost impossible given Australia's dominance in the 1990s.

Now, with Australia no longer the force it used to be, England expects. The pressure to deliver is on, the nation awaits the opportunity to taunt the old enemy once more.

But whichever team comes out on top, the world will surely be treated to another epic encounter -- just weeks before both teams do it all over again, this time in Australia.

This is one obsession which won't be ending anytime soon.

Australian cricket coach axed ahead of Ashes



England and Australia will compete for The Ashes in a five-match series



England is favorite to triumph after winning the past two editions



Australia dominated during the 1990s and early 2000s



Contest and rivalry has been running since 1882