(CNN) -- The final two teams left standing at Euro 2012 should come as no surprise, and nor should another painful exit for perennial underachievers England.

A heart-breaking defeat on penalties in their quarterfinal was preceded by 120 minutes which saw the style of finalists Italy overwhelm English pragmatism and conquer their heart-on-sleeve spirit.

So why does England continue to employ this bulldog style?

And why can't the country who gave birth to the game reinvent itself like the all-conquering Spain team, who will be gunning for a third consecutive major title against Italy in Kiev on Sunday, or the dynamic Germans, young pretenders who fell at the semifinal stage?

The answer, according to two respected authors, is history, and how the nation's deep-rooted view of masculinity has molded its soccer style. Until that changes, this relentless cycle of disappointment will continue.

David Winner, who wrote "Brilliant Orange," a study of how Dutch culture and psyche contributed to the influence their football visionaries have had on the game, argues England's approach to football has not changed for over half a century.

"The English were very true to their strengths and weaknesses at Euro 2012," Winner told CNN. "They've been losing in that way for 60 years.

"Every time it comes as surprise when English heart, commitment and valor and all these old Victorian values come unstuck against much more skilful opponents."

Italy reach semifinals after penalty kicks drama

The breeding ground for this English style of football has its roots in the boisterous games of the medieval period, Winner argues, and the intrinsic love for "testosterone festivals" like rugby, which was invented around the same time as soccer.

For him, the attritional modus operandi showcased by England during Sunday's morale-sapping defeat to a far more fluent Italy side shows the national game is still weighed down by this regressive approach.

"The game is profoundly rooted in old English stuff and we never lost that," he adds. "We love the battlers like (former England players) Terry Butcher, Stuart Pearce and Tony Adams."

"The idea the game is all about skill and you express your manliness not by fighting but by your skill in being able to do very delicate things -- that affronts something deep in the English male psyche and I don't see any change to it."

Winner's view is shared by Simon Kuper, journalist and co-author of "Soccernomics," a book about football's truths, who subscribes to the view that England's methodology was spawned from a notion that the soldier was society's greatest role model.

This then infiltrated the nation's best-loved game, reinforcing the idea of a "warrior" culture, when grit and determination were valued over technical skill. The stats from Euro 2012 back this theory up, with England blocking more shots on goal and putting in more tackles than any other nation upon their exit.

"In northern Europe, in general, we tend to value discipline and sticking to your task highly," said Kuper. "The collective discipline is important and England and Germany are examples of that. We live in countries where that is valued. You don't lose yourself in personal creativity, you do your job.

"The model for the British man is the soldier, maybe even still is. The tabloids talk about our players as soldiers, so the values that are very highly praised in English football are bravery, passion, obedience, hard work and you don't tend to hear that much talk about creativity and inspiration, which are not soldierly virtues."

But it isn't all gloom and doom for England. Hope can be extracted from two titans of Europe, Spain and Germany, both of whom radically revamped their approach to the game in the last 15 years.

For decades, Spain were one of soccer's greatest underachievers, entrenched in a style that emerged from what General Franco termed "La Furia EspaÃ±ola," or the Spanish fury. Like England, Spain's values were immersed in hard work and fight.

Time and time again Spain promised much but failed to deliver on the biggest stage. It was not until after the turn of the century their traditional tactics were abandoned, and a new style executed by a generation of emerging players started to yield unprecedented results.

Winner insists the revolution was brought about by Spanish giants Barcelona, and their modern interpretation on the Netherlands teams of the 1970s, led by Johan Cruyff, who were said to play "total football."

During his stint as manager of Barcelona, Cruyff's doctrine permeated the club, and he played a key role in the establishment of its "La Masia" youth academy that has produced so many gifted players that now make up the backbone for the national team.

"Look at how the Spanish used to play and the way they play now," Winner explains. "There's almost no point of contact between the two styles."

Reinventing the wheel: How Guardiola revolutionized football

Germany have also undergone a relatively recent transformation, shedding their traditional, battling, hardworking approach after poor returns at the 1998 World Cup in France and the European Championships two years later.

Their past triumphs in both competitions -- Germany can boast three titles in each tournament -- were conducted in a manner far removed from the way the current side operate, with skilful and exciting players like Mesut Ozil and Thomas Muller at their forefront.

German football expert Raphael Honigstein told CNN an insistence on better technical development for young players, instigated in the late 1990s and early 2000s as a result of an under-performing national side, are now starting to pay dividends.

"Those changes are apparent now -- this is the first generation to benefit," he said. "If you have those technical players at your disposal then that will affect they way you play.

"There was a realization that the Bundesliga's power and success saw an increase in foreigners and that young German players weren't coming through. One of the reasons they identified was the coaching wasn't up to scratch anymore.

"They invested lots of money into coaching and youth development and they produced better players. As a result better all-round players were being produced. They gave someone like coach Joachim Low many more options."

Germany knock Greece out of Euros

England's quarterfinal defeat has prompted a familiar round of introspection as journalists, pundits, players and managers put forward their blueprint for a bright new future.

Yet the national team's malaise is at odds with the global success enjoyed by its domestic competition.

The English Premier League is regularly described as the best, most exciting league in the world, borne out by the record amounts of money broadcasters pay to televise it. The next slab of TV rights in the UK was recently sold for Â£3 billion.

But would the Premier League punters welcome a move away from traditional values, which often provide open and frenetic matches, if it meant England were able to re-establish themselves as an international force?

"People would like England to be a winning team but they aren't willing to go through the changes to make it possible," Winner added.

"If English clubs team were good enough to play the way Spain do -- get a one goal lead and close it out by keeping the ball -- no club crowd would tolerate that for more than 20 minutes. They'd scream 'Get it upfield.'

"We'd find that boring and the crowds would stay away, and they'd also find it unmanly."

There are changes afoot though. The English Football Association told CNN its new National Football Center, which will act as a development hub for young players and coaches, is due to be handed over next week.

Prior to England's humiliating 4-1 defeat to Germany in the second round of the 2010 World Cup, the FA embarked on a process to develop a new philosophy for how the national game should be played, and it has subsequently made changes to the way youngsters are coached.

Andy Hilton, a development officer at the coalface of grassroots football in Manchester, says coaching methods and the attitude of parents who would perpetuate the "win at all costs mentality" are also starting to change.

He and his colleagues are trying to mesh the traditional English "warrior" style with the more cultured flavor of Spain and Germany, in order to produce players who are comfortable in any type of match situation.

"With the older age groups of 15 and over, the English 'warrior' is still the dominant football force. Players love street football moves to beat and humiliate an opponent but the game is high tempo, high octane power and speed with an edge of violence," Hilton said.

"Conversely with the younger players many coaches are concentrating on manipulating the ball, being comfortable with it, and not being afraid to dribble or pass it when the situation dictates.

"I suppose the question is how do we keep the tiki-taka with young adulthood from childhood? Testosterone, body changes and finding their niche in society forces players to conform to the warrior or look lesser in others' eyes."

Both Winner and Kuper agree that England needs a new model, and beginning with a detailed look at how Spain and Germany transformed their fortunes would be a productive starting point.

In the meantime, until any of these changes take hold, perhaps the best thing for English fans to do is lower expectations and prepare for an immediate future laden with modest returns.

"The future is only bleak in terms of winning tournaments -- England are not going to do that," said Winner.

"But they'll bring the nation some pleasure and get out of their group most years. They qualify for tournaments almost always.

"We have to change our expectations as a nation, stop having this post-imperial sense that we are entitled to win because we invented the game, and be a bit realistic."



Perennial underachievers England last won a major international tournament in 1966


Journalists, pundits, players and managers put forward their blueprint for a bright new future



England blocked the most shots on goal and made the most tackles while at Euro 2012



Over the last decade both Spain and Germany have reinvented the way their national teams play