#This code is a sample and not intended for production use. This AWS content is provided subject to 
#AWS customer Agreement available at https://aws.amazon.com/agreement
import os
import logging
import jsonpickle
import boto3
from datetime import datetime
from urllib.request import Request, urlopen
from aws_xray_sdk.core import xray_recorder
from aws_xray_sdk.core import patch_all
import multiprocessing

SITE = os.environ['site']  # URL of the site to check, stored in the site environment variable
EXPECTED = os.environ['expected']  # String expected to be on the page, stored in the expected environment variable
PROCESSCOUNT = int(os.environ['processCount'])
ITERATIONS = int(os.environ['iterationCount'])


logger = logging.getLogger()
logger.setLevel(logging.INFO)
patch_all()
cloudwatch_client = boto3.client('cloudwatch')
client = boto3.client('lambda')
client.get_account_settings()

def validate(res):
  '''Return False to trigger the canary
  Currently this simply checks whether the EXPECTED string is present.
  However, you could modify this to perform any number of arbitrary
  checks on the contents of SITE.
  '''
  print(res)
  return EXPECTED in res
  
  
  
  
  
def lambda_handler(event, context):
  
    # Number of processes to create
    # the job list 
    jobs = []
    for i in range(0, PROCESSCOUNT):
        process = multiprocessing.Process(target=loop_and_call_api(event, context))
        jobs.append(process)

    # Start the threads (i.e. calculate the random number lists)
    for j in jobs:
        j.start()

    # Ensure all of the threads have finished
    for j in jobs:
        j.join()

    print ("Parallel processing with Multi Process module complete.")

def loop_and_call_api(event, context):  
    for i in range(ITERATIONS):
       print("iteration::" , i)
       call_api(event, context)  
   
  
def call_api(event, context):  
  print(event)
  print('Checking {}'.format(SITE))
  try:
    start_time=datetime.now()
    req = Request(SITE, headers={'User-Agent': 'AWS Lambda'})
    end_time=datetime.now()
    diff=((end_time-start_time).total_seconds()) *1000
    print(diff)
    response = cloudwatch_client.put_metric_data(
    Namespace='webtracing',
    MetricData=[
        {
            'MetricName': 'response_time',
            'Dimensions': [
                {
                    'Name': 'function-name',
                    'Value': 'endpoint'
                },
            ],
            'Timestamp': str(datetime.now()),
            'Value': diff,
            'Unit': 'Milliseconds',
            'StorageResolution':1
        },
    ]
    )
    if not validate(str(urlopen(req).read())):
      raise Exception('Validation failed')
  except:
    print('Check failed!')
    raise
  else:
      print('Check passed!')
      return str(datetime.now())
  finally:
      print('Check complete at {}'.format(str(datetime.now())))


