#!/usr/bin/env bash
  echo "********************************** Running Step 21 **********************************"
  #Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");
  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
  if [ -z $Account_Id ]; then
    echo "Account ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi

  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
  if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
  fi

  echo "Submitting RFC for Windows Development 1"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""/Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step35_CreatePatchWindowsDevelopmentParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step_35_Create_Patch_Windows Development 1 RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step_35_Create_Patch_ Windows Development 1 RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step_35_Create_Patch_Windows Development 1 RFC  has been submitted" | tee -a Account_Onboarding_Report.txt
        fi

  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step_35_Create_Patch_ Windows Development 1 RFC Creation Failed, Exiting"
    exit 1
  fi


  echo "Step 36 Submitting RFC for Windows Development 2"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step36_CreatePatchWindowsDevelopment2Params.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step_36_Create_Patch_Window RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step_36_Create_Patch_Windows Development 2 RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step_36_Create_Patch_Windows  1 RFC  has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step_36_Create_Patch_Window 2 RFC Creation Failed, Exiting"
    exit 1
  fi


  echo "Step 37 Submitting RFC for Windows Test"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step37_CreatePatchWindowsTestParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)
  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 37 Submitting RFC for Windows Test RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 37 Submitting RFC for Windows Test RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 37 Submitting RFC for Windows Test RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 37 Submitting RFC for Windows Test RFC Creation Failed, Exiting"
    exit 1
  fi

  echo "Step 38 Submitting RFC for Windows Test 2"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step38_CreatePatchWindowsTest2Params.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 38 Submitting RFC for Windows Test 2 RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 38 Submitting RFC for Windows Test 2 RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 38 Submitting RFC for Windows Test 2 RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 38 Submitting RFC for Windows Test 2 RFC Creation Failed, Exiting"
    exit 1
  fi


  echo "Step 39 Submitting RFC for Windows Prod"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step39_CreatePatchWindowsProdParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 39 Submitting RFC for Windows Prod RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 39 Submitting RFC for Windows Prod RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 39 Submitting RFC for Windows Prod RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 39 Submitting RFC for Windows Prod RFC Creation Failed, Exiting"
    exit 1
  fi

  echo "Step 40 Submitting RFC for Windows Prod 2"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step40_CreatePatchWindowsProd2Params.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.

  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 40 Submitting RFC for Windows Prod 2 RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 40 Submitting RFC for Windows Prod 2 RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 40 Submitting RFC for Windows Prod 2 RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 40 Submitting RFC for Windows Prod 2 RFC Creation Failed, Exiting"
    exit 1
  fi

  echo "Step 41 Submitting RFC for Linux Development"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step41_CreatePatchLinuxDevelopmentParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 41 Submitting RFC for Linux Development RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 41 Submitting RFC for Linux Development RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 41 Submitting RFC for Linux Development RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 41 Submitting RFC for Linux Development RFC Creation Failed, Exiting"
    exit 1
  fi


  echo "Step 42 Submitting RFC for Linux test"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step42_CreatePatchLinuxTestParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 42 Submitting RFC for Linux test RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 42 Submitting RFC for Linux test RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 42 Submitting RFC for Linux test RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 42 Submitting RFC for Linux test RFC Creation Failed, Exiting"
    exit 1
  fi


  echo "Step 43 Submitting RFC for Linux prod"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""Step_35_Create_Patch_Window_Rfc.json"  --execution-parameters file://"$PathToMainFolder""Step43_CreatePatchLinuxProdParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 43 Submitting RFC for Linux prod RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 43 Submitting RFC for Linux prod RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 43 Submitting RFC for Linux prod RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 43 Submitting RFC for Linux prod RFC Creation Failed, Exiting"
    exit 1
  fi

  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
  echo $PathToMainFolder
  Step45_PathToFolder=("$PathToMainFolder""Step45_CreateSpecialRHELBaselineMOOParams.json")
  echo $Step45_PathToFolder


  # Building the JSON for step_45
  echo "{" > "$Step45_PathToFolder"
  echo "\"Comment\": \"Name - RHELBaseline Patch Group tag values - LinuxProduction, LinuxTest, LinuxDevelopment Operating System - Red Hat Enterprise Linux Approval Rules: Severity - Critical, Important, Moderate Classification - All security and bug fixes for the OS that exclude minor version and kernel upgrades \"," | tee -a "$Step45_PathToFolder"
  echo "\"Priority\": \"High\"" | tee -a "$Step45_PathToFolder"
  echo "}"  | tee -a "$Step45_PathToFolder"


  echo "Step 45 Submitting RFC for Linux REHL Base"
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""/Step_35_REHL_BaseLine_Patch.json"  --execution-parameters file://"$PathToMainFolder""/Step45_CreateSpecialRHELBaselineMOOParams.json" --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Step 45 Submitting RFC for Linux REHL Base RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Step 45 Submitting RFC for Linux REHL Base RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "Step 45 Submitting RFC for Linux REHL RFC has been submitted" | tee -a Account_Onboarding_Report.txt
        fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Step 45 Submitting RFC for Linux REHL Base RFC Creation Failed, Exiting"
    exit 1
  fi

  # Print last command status
  echo $?






