#!/usr/bin/env bash
  set e
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");
  # lookup the account ID
  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
  if [ -z $Account_Id ]; then
   echo "Account ID lookup Failed"  | tee -a Error_Log.txt
   exit 1
  fi

  #### Onboard to Patch orchestrator  ####
  # File AMS RFC to provision self serv AWS service for Patch orchestrator
  Patch_Orchestrator=$(aws support create-case --subject 'Onboard account to patch orchestrator' --service-code 'sentinel-service-request' --category-code 'feature-request' --severity-code 'normal' --cc-email-addresses 'EAMIL' --communication-body 'AccountId :'$Account_Id'\r\nFirstTagKey:   FirstTagKey\r\nSecondTagKey:  SecondTagKey\r\nThirdTagKey:   ThirdTagKey\r\nRegion:  us-east-1\r\nDefaultMaintenanceWindowCutoff:   1\r\nDefaultMaintenanceWindowDuration:   4\r\nDefaultMaintenanceWindowSchedule:   cron(0 18 1 * ? *)\r\nDefaultMaintenanceWindowTimeZone:   UTC\r\nDefaultPatchBackupRetentionInDays:   30\r\nNotificationEmails:   EMAIL\r\n' --output text)
   # Store SR info
   SR_Status=$(aws support describe-cases --case-id $Patch_Orchestrator --output json)
   echo "$SR_Status" >  SR_Temp.json
   Case_ID=$(jq -rc .cases[0].displayId SR_Temp.json)

  echo "Filing CR to onboard account to onboard account to patch orchestrator"
  # Check if the length of the return is larger than 20 which means an SR has been created.
  Case_ID=$(jq -rc .cases[0].displayId SR_Temp.json)
  if [ -z $Case_ID ]; then
    echo "Case ID  in step 20 failed"  | tee -a Error_Log.txt
    exit 1
  fi
  echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using SR," "**"$Case_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt


  # ***** Recommend adding more error handeling logic ********
  if [ -z $Patch_Orchestrator ]; then
   echo "Account ID lookup Failed"  | tee -a Error_Log.txt
   exit 1
  fi

  echo $?