#!/usr/bin/env bash
  echo "********************************** Running Step 20 **********************************"
  #Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");

   # lookup the account ID
   Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
   if [ -z $Account_Id ]; then
       echo "Account ID lookup in step 20 failed"  | tee -a Error_Log.txt
      exit 1
   fi

   #### Attach rule for config rule  ####
   config_rule_SR=$(aws support create-case --subject 'CFN template attachment for RFC ingestion for Config SNS subscription' --service-code 'sentinel-service-request' --category-code 'feature-request' --severity-code 'normal' --cc-email-addresses 'EMAIL' --communication-body 'AccountId :'$Account_Id'' --output text)
   #Store SR info
   echo $config_rule_SR
   SR_Status=$(aws support describe-cases --case-id $config_rule_SR --output json)
   echo $SR_Status
   Case_ID=$(jq -rc .cases[0].displayId SR_Status)

   echo  "$SR_Status" >  SR_Temp.json
   Case_ID=$(jq -rc .cases[0].displayId SR_Temp.json)
   if [ -z $Case_ID ]; then
     echo "Case ID  in step 20 failed"  | tee -a Error_Log.txt
     exit 1
   fi
   echo $Case_ID

   echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using SR ID," "**"$Case_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt


   echo "Filing CR  to attach config template"
   if [ -z $config_rule_SR ]; then
       echo "SR creation in step 20 failed"  | tee -a Error_Log.txt
      exit 1
   fi

#  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
#  Step21_PathToFolder=("$PathToMainFolder""Step21_CreateIngestCFNMOOParams.json")
#  if [ -z $PathToMainFolder ]; then
#    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
#    exit 1
#  fi
#
#    # Input params for step 21
#    echo "{" > "$Step21_PathToFolder"
#    echo "\"Comment\": \"Create CF Stack from SR in related IDs  (CF template file attached to that SR) with StackName - ConfigRulesv1" "\"," | tee -a "$Step21_PathToFolder"
#    echo "\"RelatedIds\": "["\"$Case_ID\""] "," | tee -a "$Step21_PathToFolder"
#    #echo "\"RelatedIds\": "["\"$Topic_ARN\""] "," | tee -a "$Step17_PathToFolder"
#    echo "\"Priority\": \"High\"" | tee -a "$Step21_PathToFolder"
#    echo "}"  | tee -a "$Step21_PathToFolder"
#
#  # Print last command status
   echo $?
