#!/usr/bin/env bash

  echo "********************************** Running Step 18 **********************************"
  #Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");
  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
  if [ -z $Account_Id ]; then
    echo "Account ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi

  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
  Step18_PathToFolder=("$PathToMainFolder""Step_18_Create_Config_SNS_Topic_Params.json")

  if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
  fi

  #lookup the account ID
  VPC_Id=$(jq -rc .Resources.VPCIds.VPCId Account_Config.json)
  if [ ${#VPC_Id} -le 2 ]; then
    echo "VPC lookup in step 18 failed" | tee -a Error_Log.txt
    exit 1
  fi

   # Input params for step 09
   echo "{" >  "$Step18_PathToFolder"
   echo "\"Description\": "\"SNS Topic for client AMS config remediation rules\""," | tee -a "$Step18_PathToFolder"
   echo "\"VpcId\": "\"$VPC_Id"\"", | tee -a  "$Step18_PathToFolder"
   echo "\"Name\": "\"Client_AMS_Config_SNS_Topics\" "," | tee -a "$Step18_PathToFolder"
   echo "\"StackTemplateId"\"": "\"stm-eakrsalqo9m62tpun"\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"TimeoutInMinutes"\": 60 "," | tee -a "$Step18_PathToFolder"

   echo "\"Parameters"\""":  | tee -a "$Step18_PathToFolder"
   echo "{"  | tee -a "$Step18_PathToFolder"
   echo "\"TopicName"\"": "\"Client_AMS_Config_SNS_Topics\" "," | tee -a "$Step18_PathToFolder"
   echo "\"DisplayName"\"": "\"GuardDuty\" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription1Protocol"\"": "\"email\" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription1Endpoint"\"": "\"EMAIL\" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription1RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription2Endpoint"\"": "\""\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription2RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription3Endpoint"\"": "\""\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription3RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription4Endpoint"\"": "\""\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"Subscription4RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step18_PathToFolder"

   echo "\"Subscription5Endpoint"\"": "\" "\"" "," | tee -a Step_14_CreateSNSTopicParams.json
   echo "\"Subscription5RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step18_PathToFolder"
   echo "\"KmsMasterKeyId\": \"ARN\"" | tee -a "$Step18_PathToFolder"
   echo "}"  | tee -a "$Step18_PathToFolder"
   echo "}"  | tee -a "$Step18_PathToFolder"

   # This script uses jq to manage Bash interaction with JSON
   echo "Beginning script to create SNS topic"
   # Clearing out file
   echo " " > RFC_Status.json
   #Creating the SNS RFC
   AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder"/Step_18_Create_Config_SNS_RFC.json  --execution-parameters file://"$PathToMainFolder""/Step_18_Create_Config_SNS_Topic_Params.json" --output json)
   echo "$AMS_RFC" > RFC_ID_Temp.json
   AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

   # Check if the length of the return is larger than 20 which means an RFC has been created.
   if [ ${#AMS_RFC_ID} -ge 20 ]; then
   echo "Step_18_Create_Config_SNS RFC created successfully"
   RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
   if (RFC_Status="Editing" ); then
        echo "Step_18_Create_Config_SNS RFC Ready for Submission"
        RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
        echo "Step_18_Create_Config_SNS RFC to create Cloudhealth Role has been submitted"
   fi

   fi

   if [ ${#AMS_RFC_ID} -le 20 ]; then
        echo "Step_18_Create_Config_SNS RFC Creation Failed, Exiting" | tee -a Error_Log.txt
        exit 1
   fi

   # Check status of the RFC and store into a temp local file
   RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output json)
   echo "Saving RFC Status"
   echo "$RFC_Status" > RFC_Status.json

  # Look up the Status of the RFC in the JSON
  AMSRFC_temp=$(jq -rc .Rfc.Status.Name RFC_Status.json)

  if [ ${#AMSRFC_temp} -le 2 ]; then
    echo "RFC Status lookup failed in Step_18_Create_Config_SNS, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

# Manage RFC status and only exit if success or failure
  while [ "$AMSRFC_temp" != "Success" ]
  do
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output json)
    echo "$RFC_Status" > RFC_Status.json
    # Look up the RFC status in the JSON
    AMSRFC_temp=$(jq -rc .Rfc.Status.Name RFC_Status.json)
    #Check what status the RFC is in
    if [ "$AMSRFC_temp" = "InProgress" ] | [ "$AMSRFC_temp" = "PendingApproval" ] ; then
      Sleep 5
      echo  "Step_18_Create_Config_SNS RFC creation in progress"
    fi

    if [ "$AMSRFC_temp" = "Canceled" ] | [ "$AMSRFC_temp" = " " ] | [ "$AMSRFC_temp" = "Rejected" ] | [ "$AMSRFC_temp" = "Failure" ] ; then
      echo  "Exiting, Step_18_Create_Config_SNS RFC is incomplete"
      exit 1
    fi

    if [ "$AMSRFC_temp" = "Succes" ]; then
        echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
        echo "Step_18_Create_Config_SNS RFC Completed Successfully" | tee -a Account_Onboarding_Report.txt
    fi
  done

  # lookup the topic ARN
  Topic_ARN_temp=$(jq -rc .Rfc.ExecutionOutput RFC_Status.json)
  echo "$Topic_ARN_temp" > temp.json

  if [ ${#Topic_ARN_temp} -le 2 ]; then
    echo "Step_18_Create_Config_SNS topic ARN temp lookup Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

  Topic_ARN=$(jq -rc .outputs[0].value temp.json)
    echo $Topic_ARN

  if [ ${#Topic_ARN} -le 2 ]; then
    echo "Step_18_Create_Config_SNS topic ARN lookup Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

   PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
   Step19_PathToFolder=("$PathToMainFolder""Step19_Update_IAM_Resource_Params.json")

   if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
   fi
   # Interminent issue with JSOn formatting that seems to be fixed with a 2 second pause during execution
   sleep 2
   # Input params for step 19
   echo "{" > "$Step19_PathToFolder"
   echo "\"Comment\": \"{ \\\"Statement\\\": [{ \\\"Effect\\\":\\\"Allow\\\", \\\"Principal\\\":\\\"*\\\", \\\"Action\\\":\\\"sqs:SendMessage\\\", \\\"Resource\\\":\\\"ARN_HERE\\\", \\\"Condition\\\":{ \\\"ArnEquals\\\":{ \\\"aws:SourceArn\\\":\\\"arn:aws:sns:us-east-1:<appaccountID>:GuardDutySNSTopic\\\" } } }] }\\r\" ,"| tee -a "$Step19_PathToFolder"
   echo "\"RelatedIds\": "["\"$Topic_ARN\""]"," | tee -a "$Step19_PathToFolder"
   echo "\"Priority\": \"High\"" | tee -a "$Step19_PathToFolder"
   echo "}"  | tee -a "$Step19_PathToFolder"


  # Print last command status
  echo $?
