#!/usr/bin/env bash
  echo "********************************** Running Step 15 **********************************"
  #Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
  if [ -z $Account_Id ]; then
    echo "Account ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");

  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)

  if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
  fi
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder"/Step_15_CreateCloudWatchEventRuleRFC.json  --execution-parameters file://"$PathToMainFolder"/Step15_CreateCloudWatchEventRuleMOOParams.json --output json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "Create Cloud Watch EventRule RFC created successfully"
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
        if (RFC_Status="Editing" ); then
            echo "Create Cloud Watch Event Rule RFC Ready for Submission"
            RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
            echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
            echo "RFC to create Create Cloud Watch Event Rule  has been submitted" | tee -a Account_Onboarding_Report.txt
        fi

  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "Create Cloud Watch Event Rule RFC Creation Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

  # Print last command status
  echo $?
