#!/usr/bin/env bash

  echo "********************************** Running Step 14 **********************************"
  #Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
  Step14_PathToFolder=("$PathToMainFolder""Step_14_CreateSNSTopicParams.json")
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");
  
  if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
  fi

  # lookup the account ID
  VPC_Id=$(jq -rc .Resources.VPCIds.VPCId Account_Config.json)
  Key_ARN=$(jq -rc .outputs[1].value temp.json)
  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)

  if [ -z $Account_Id ]; then
    echo "Account ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi

  # Check if value is a valid value
  if [ ${#VPC_Id} -le 5 ]; then
    echo "Error getting VPC ID" | tee -a Error_Log.txt
    exit 1
  fi

  # Check if value is a valid value
  if [ ${#Key_ARN} -le 5 ]; then
    echo "Error getting Key ARN" | tee -a Error_Log.txt
    exit 1
  fi

  #Input params for step 09
  echo "{" >  "$Step14_PathToFolder"
  echo "\"Description\": "\"GuardDutySNSTopic\""," | tee -a "$Step14_PathToFolder"
  echo "\"VpcId\": "\"$VPC_Id"\"", | tee -a  "$Step14_PathToFolder"
  echo "\"Name\": "\"GuardDutySNSTopic\" "," | tee -a "$Step14_PathToFolder"
  echo "\"StackTemplateId"\"": "\"stm-eakrsalqo9m62tpun"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"TimeoutInMinutes"\": 60 "," | tee -a "$Step14_PathToFolder"

  echo "\"Tags\": ""[{" | tee -a  "$Step14_PathToFolder"
  #echo "{" > Step_14_CreateSNSTopicParams.json

  echo "\"Key\": "\"ITLT Owner\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"VALUE\"  | tee -a "$Step14_PathToFolder"
  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key\": "\"Cost Center\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"00000\"  | tee -a "$Step14_PathToFolder"
  #echo "},"  | tee -a Step_14_CreateSNSTopicParams.json

  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key\": "\"OwnerTeamEmail\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"VALUE\"  | tee -a "$Step14_PathToFolder"
  #echo "},"  | tee -a Step_14_CreateSNSTopicParams.json

  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key\": "\"System\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"VALUE\"  | tee -a "$Step14_PathToFolder"
  #echo "},"  | tee -a Step_14_CreateSNSTopicParams.json

  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key\": "\"SystSystem Owner\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"VALUE\"  | tee -a "$Step14_PathToFolder"
  #echo "},"  | tee -a Step_14_CreateSNSTopicParams.json

  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key\": "\"System Admin\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"VALUE\"  | tee -a "$Step14_PathToFolder"
  #echo "},"  | tee -a Step_14_CreateSNSTopicParams.json

  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key\": "\"Environment\" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"Production\"  | tee -a "$Step14_PathToFolder"
  #echo "}"  | tee -a Step_14_CreateSNSTopicParams.json

  echo "},{"  | tee -a "$Step14_PathToFolder"
  echo "\"Key"\"": "\"Name"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Value\": "\"GuardDutySNSTopic\"  | tee -a "$Step14_PathToFolder"
  echo "}"  | tee -a "$Step14_PathToFolder"
  echo "],"  | tee -a "$Step14_PathToFolder"

  echo "\"Parameters"\""":  | tee -a "$Step14_PathToFolder"
  echo "{"  | tee -a "$Step14_PathToFolder"
  echo "\"TopicName"\"": "\"GuardDutySNSTopic"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"DisplayName"\"": "\"GuardDuty"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription1Protocol"\"": "\"sqs"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription1Endpoint"\"": "\"ARN"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription1RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step14_PathToFolder"

  echo "\"Subscription2Endpoint"\"": "\""\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription2RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription3Endpoint"\"": "\""\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription3RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription4Endpoint"\"": "\""\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription4RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step14_PathToFolder"

  echo "\"Subscription5Endpoint"\"": "\""\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"Subscription5RawMessageDelivery"\"": "\"false"\"" "," | tee -a "$Step14_PathToFolder"
  echo "\"KmsMasterKeyId\": \"$Key_ARN\"" | tee -a "$Step14_PathToFolder"
  echo "}"  | tee -a "$Step14_PathToFolder"
  echo "}"  | tee -a "$Step14_PathToFolder"

  #This script uses jq to manage Bash interaction with JSON
  echo "Beginning script to create SNS topic"
  # Clearing out file
  #echo " " > RFC_Status.json
  #Creating the SNS RFC
  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""/CreateSNSTopic.json"  --execution-parameters file://"$PathToMainFolder""/Step_14_CreateSNSTopicParams.json" --output json)
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  echo $AMS_RFC_ID

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "RFC created successfully for SNS Topic"
    #Submit the RFC and store the return RFC ID into a temp JSON file
    RFC_Status_temp=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
    echo "SNS Topic  has been submitted"
    # Check status of the RFC and store into a temp local file
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output json)
    echo "$RFC_Status" > RFC_Status.json
  fi

  if [ ${#AMS_RFC} -le 20 ]; then
    echo " Step_14_CreateSNSTopic Creation Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

  # Look up the Status of the RFC in the JSON
  AMSRFC_temp=$(jq -rc .Rfc.Status.Name RFC_Status.json)
  if [ ${#AMSRFC_temp} -le 5 ]; then
    echo " RFC_Status Lookup Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

  # Manage RFC status and only exit if success or failure
  while [ "$AMSRFC_temp" != "Success" ]
  do
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output json)
    echo "$RFC_Status" > RFC_Status.json
    # Look up the RFC status in the JSON
    AMSRFC_temp=$(jq -rc .Rfc.Status.Name RFC_Status.json)
    #Check what status the RFC is in
    if [ "$AMSRFC_temp" = "InProgress" ] | [ "$AMSRFC_temp" = "PendingApproval" ] ; then
      Sleep 5
      echo  "Step_14 RFC creation in progress"
    fi

    if [ "$AMSRFC_temp" = "Canceled" ] | [ "$AMSRFC_temp" = " " ] | [ "$AMSRFC_temp" = "Rejected" ] | [ "$AMSRFC_temp" = "Failure" ] ; then
      echo  "Exiting, Step_14 RFC is incomplete"
      exit 1
    fi

    if [ "$AMSRFC_temp" = "Succes" ]; then
     echo "Step_14 RFC creation Completed Successfully" | tee -a Account_Onboarding_Report.txt
     echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt

    fi
  done

  # lookup the topic ARN
  Topic_ARN_temp=$(jq -rc .Rfc.ExecutionOutput RFC_Status.json)
  echo "$Topic_ARN_temp" > temp.json

  if [ ${#Topic_ARN_temp} -le 5 ]; then
    echo " Step_14_CreateSNSTopic Creation Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi

  Topic_ARN=$(jq -rc .outputs[0].value temp.json)

  if [ ${#Topic_ARN} -le 5 ]; then
    echo " Step_14_CreateSNSTopic Creation Failed, Exiting" | tee -a Error_Log.txt
    exit 1
  fi


  Step15_PathToFolder=("$PathToMainFolder""Step15_CreateCloudWatchEventRuleMOOParams.json")
  # Input params for step 15
  #Step_15_Input= "Step15_CreateCloudWatchEventRuleMOOParams.json"
  echo "{" > "$Step15_PathToFolder"
  echo "\"Comment\": \"Rule Name - GuardDutySNSEvents  EVENT Source  Event Pattern Service Name: GuardDutyEvent, Type: All Events TARGETS - SNS Topic  Topic - \"," | tee -a "$Step15_PathToFolder"
  echo "\"RelatedIds\": "["\"$Topic_ARN\""]"," | tee -a "$Step15_PathToFolder"
  echo "\"Priority\": \"High\"" | tee -a "$Step15_PathToFolder"
  echo "}"  | tee -a "$Step15_PathToFolder"

  Step16_PathToFolder=("$PathToMainFolder""Step16_CreateSNSTopicPolicyMOOParams.json")
  # Input params for step 16
  echo "{" > "$Step16_PathToFolder"
  echo "\"Comment\": \"{ \\\"Statement\\\":[{ \\\"Effect\\\":\\\"Allow\\\", \\\"Principal\\\":{ \\\"AWS\\\":\\\"ACCOUNT_ID\\\"},\\\"Action\\\":\\\"sns:Subscribe\\\",\\\"Resource\\u201D:\\u201DAMS operator , please refer to related ID\\u201C}]} - \"," | tee -a "$Step16_PathToFolder"
  echo "\"RelatedIds\": "["\"$Topic_ARN\""]"," | tee -a "$Step16_PathToFolder"
  echo "\"Priority\": \"High\"" | tee -a "$Step16_PathToFolder"
  echo "}"  | tee -a "$Step16_PathToFolder"

  Step17_PathToFolder=("$PathToMainFolder""Step17_CreateSQSPermissionMOOParams.json")
  # Input params for step 17
  echo "{" > "$Step17_PathToFolder"
  echo "\"Comment\": "\" "{\\\"Statement\\\": [{\\\"Effect\\\": \\\"Allow\\\",\\\"Principal\\\": \\\"*\\\",\\\"Action\\\": \\\"sqs: SendMessage\\\",\\\"Resource\\\": \\\"ARN_HERE\\\",\\\"Condition\\\": {\\\"ArnEquals\\\": {\\\"aws: SourceArn\\\": \\\"AMSoperatorpleaseconsultrelatedfieldsvalue\\\"}}}]}" \" "," | tee -a "$Step17_PathToFolder"
  echo "\"RelatedIds\": "["\"$Topic_ARN\""] "," | tee -a "$Step17_PathToFolder"
  echo "\"Priority\": \"High\"" | tee -a "$Step17_PathToFolder"
  echo "}"  | tee -a "$Step17_PathToFolder"

  # Print last command status
  echo $?