#!/usr/bin/env bash
  echo "********************************** Running Step 12 **********************************"

  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");

  # lookup the account ID
  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
  if [ -z $Account_Id ]; then
    echo "Account ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi

  if [ -z $Account_Id ]; then
    echo "Account Id lookup Failed"  | tee -a Error_Log.txt
    exit 1
   fi
  # Set e will force exit if any error happen or any thread returns other than 0 return
  #lookup the VPC ID
  VPC_Id=$(jq -rc .Resources.VPCIds.VPCId Account_Config.json)
   if [ -z $VPC_Id ]; then
     echo "VPC ID lookup Failed"  | tee -a Error_Log.txt
     exit 1
   fi

   PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
   Step12_PathToFolder=("$PathToMainFolder""Step_12_CreateKMSKeyParams.json")

   if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
   fi

   # Input params for step 09
   echo "{" > "$Step12_PathToFolder"
   echo "\"Description"\"": "\"KMS key for SNS Topic"\"" "," | tee -a "$Step12_PathToFolder"
   echo "\"VpcId"\"": "\"$VPC_Id"\"", | tee -a "$Step12_PathToFolder"
   echo "\"Name"\"": "\"my-app-key-encryption-keys"\"" "," | tee -a "$Step12_PathToFolder"
   echo "\"StackTemplateId"\"": "\"stm-enf1j068fhg34vugt"\"" "," | tee -a "$Step12_PathToFolder"
   echo "\"TimeoutInMinutes"\": 60 "," | tee -a "$Step12_PathToFolder"
   echo "\"Parameters"\""": "{" | tee -a "$Step12_PathToFolder"
   echo "\"Description"\"": "\"KMS key for SNS Topic"\"" | tee -a "$Step12_PathToFolder"
   echo "}"  | tee -a "$Step12_PathToFolder"
   echo "}"  | tee -a "$Step12_PathToFolder"

   # This script uses jq to manage Bash interaction with JSON
   # Clearing out file
   #echo " " > RFC_Status.json
   #Creating the SNS RFC
   AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""/Step_12_CreateKMSKeyRFC.json" --execution-parameters file://"$PathToMainFolder""/Step_12_CreateKMSKeyParams.json" --output json)
   echo "$AMS_RFC" > RFC_Status.json
   #echo $AMS_RFC
   AMS_RFC_ID=$(jq -rc .RfcId RFC_Status.json)
   #echo $AMS_RFC_ID

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo "RFC created successfully for KMS Key"
    #Submit the RFC and store the return RFC ID into a temp JSON file
    RFC_Status_temp=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
    echo "KMS Key has been submitted"
    # Check status of the RFC and store into a temp local file
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output json)
    echo "$RFC_Status" > RFC_Status.json
  fi
   if [ ${#AMS_RFC_ID} -le 20 ]; then
       echo " KMS Key Creation Failed, Exiting" | tee -a Error_Log.txt
       exit 1
   fi
  # Look up the Status of the RFC in the JSON
  AMSRFC_temp=$(jq -rc .Rfc.Status.Name RFC_Status.json)

   if [ ${#AMSRFC_temp} -le 2 ]; then
    echo "RFC Lookup Failed, Exiting" | tee -a Error_Log.txt
    exit 1
   fi
  #Manage RFC status and only exit if success or failure
  while [ "$AMSRFC_temp" != "Success" ]
  do
    RFC_Status=$(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output json)
    echo "$RFC_Status" > RFC_Status.json
    # Look up the RFC status in the JSON
    AMSRFC_temp=$(jq -rc .Rfc.Status.Name RFC_Status.json)
    #Check what status the RFC is in
    if [ "$AMSRFC_temp" = "InProgress" ] | [ "$AMSRFC_temp" = "PendingApproval" ] ; then
      Sleep 5
      echo  "RFC creation in progress"
    fi

    if [ "$AMSRFC_temp" = "Canceled" ] | [ "$AMSRFC_temp" = " " ] | [ "$AMSRFC_temp" = "Rejected" ] | [ "$AMSRFC_temp" = "Failure" ] ; then
      echo  "Exiting, RFC is incomplete"
      exit 1
    fi

    if [ "$AMSRFC_temp" = "Succes" ]; then
      echo "RFC Completed Successfully"
      echo "RFC created successfully for KMS Key" | tee -a Account_Onboarding_Report.txt
      echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
    fi
  done
  # lookup the topic ARN
    Key_ARN_temp=$(jq -rc .Rfc.ExecutionOutput RFC_Status.json)
    echo "$Key_ARN_temp" > temp.json
    echo $Key_ARN_temp

   if [ ${#Key_ARN_temp} -le 2 ]; then
    echo " Key ARN Lookup Failed, Exiting" | tee -a Error_Log.txt
    exit 1
   fi

  Key_ARN=$(jq -rc .outputs[1].value temp.json)
  echo $Key_ARN

   if [ ${#Key_ARN} -le 2 ]; then
    echo " Key ARN Lookup Failed, Exiting" | tee -a Error_Log.txt
    exit 1
   fi

  PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
  Step13_PathToFolder=("$PathToMainFolder""Step13_CreateAddKMSKeyMOOParams.json")
  if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
  fi

  # Input params for step 13
  echo "{" > "$Step13_PathToFolder"
  echo "\"Comment\": \"Please add policy for Key ID: AMS Operator, please consult related ID { \\\"Version\\\": \\\"2012-10-17\\\", \\\"Statement\\\": [{ \\\"Effect\\\": \\\"Allow\\\", \\\"Principal\\\": {\\\"Service\\\": \\\"events.amazonaws.com\\\"}, \\\"Action\\\": [\\\"kms:GenerateDataKey*\\\", \\\"kms:Decrypt\\\"], \\\"Resource\\\": \\\"*\\\"}]}\","| tee -a "$Step13_PathToFolder"
  echo "\"RelatedIds\": "["\"$Key_ARN\""]"," | tee -a "$Step13_PathToFolder"
  echo "\"Priority\": \"High\"" | tee -a "$Step13_PathToFolder"
  echo "}"  | tee -a "$Step13_PathToFolder"

  # Print last command status
  echo $?



