#!/usr/bin/env bash
  echo "********************************** Running Step 09 **********************************"
  # Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  #Get date and time
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  # Get current script name
  Step_Name=$(basename -- "$0");

  #lookup the account ID
  VPC_Id=$(jq -rc .Resources.VPCIds.VPCId Account_Config.json)
  if [ -z $VPC_Id ]; then
    echo "VPC ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi

   PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
   Step9_PathToFolder=("$PathToMainFolder""Step09_CreateBronzeBackupPlanParams.json")
   if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
   fi

   # Input params for step 09
   echo "{" > "$Step9_PathToFolder"
   echo "\"VpcId"\"": "\"$VPC_Id"\"", | tee -a "$Step9_PathToFolder"
   echo "\"Description"\"": "\"Bronze Backup Plan"\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"Parameters"\""": "{" | tee -a "$Step9_PathToFolder"
   echo "\"BackupPlanName"\"": "\"Bronze"\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"ResourceTagKey"\"": "\"RPO"\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"ResourceTagValue"\"": "\"Bronze"\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1Name"\"": "\"BronzeBackupRule1"\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1Vault"\"": "\"ams-custom-backups"\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1CompletionWindowMinutes"\": 180 "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1DeleteAfterDays"\": 36 "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1MoveToColdStorageAfterDays"\": 15 "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1StartWindowMinutes"\": 60 "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1RecoveryPointTagKey"\"": "\""\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1RecoveryPointTagValue"\"": "\""\"" "," | tee -a "$Step9_PathToFolder"
   echo "\"BackupRule1ScheduleExpression"\"": "\""cron(0 10 ? * * *)"\""" | tee -a "$Step9_PathToFolder"
   echo "},"  | tee -a "$Step9_PathToFolder"
   echo "\"StackTemplateId\": ""\"stm-sc68a620000000000"\""," | tee -a "$Step9_PathToFolder"
   echo "\"TimeoutInMinutes\": 60," | tee -a "$Step9_PathToFolder"
   echo "\"Name\": \"TEST_STACK\"" | tee -a "$Step9_PathToFolder"
   echo "}"  | tee -a "$Step9_PathToFolder"


   PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
   Step10_PathToFolder=("$PathToMainFolder""Step10_CreateSilverBackUpPlanParams.json")
   if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
   fi

   # Input params for step 10
   echo "{" > "$Step10_PathToFolder"
   echo "\"VpcId"\"": "\"$VPC_Id"\"", | tee -a "$Step10_PathToFolder"
   echo "\"Description"\"": "\"Bronze Backup Plan"\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"Parameters"\""": "{" | tee -a "$Step10_PathToFolder"
   echo "\"BackupPlanName"\"": "\"Silver Backup Plan"\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"ResourceTagKey"\"": "\"RPO"\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"ResourceTagValue"\"": "\"Silver"\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1Name"\"": "\"SilverBackupRule1"\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1Vault"\"": "\"ams-custom-backups"\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1CompletionWindowMinutes"\": 180 "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1DeleteAfterDays"\": 36 "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1MoveToColdStorageAfterDays"\": 15 "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1StartWindowMinutes"\": 60 "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1RecoveryPointTagKey"\"": "\""\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1RecoveryPointTagValue"\"": "\""\"" "," | tee -a "$Step10_PathToFolder"
   echo "\"BackupRule1ScheduleExpression"\"": "\""cron(0 10/12 ? * * *)"\""" | tee -a "$Step10_PathToFolder"
   echo "},"  | tee -a "$Step10_PathToFolder"
   echo "\"StackTemplateId\": ""\"stm-sc68a620000000000"\""," | tee -a "$Step10_PathToFolder"
   echo "\"TimeoutInMinutes\": 60," | tee -a "$Step10_PathToFolder"
   echo "\"Name\": \"TEST_STACK\"" | tee -a "$Step10_PathToFolder"
   echo "}"  | tee -a "$Step10_PathToFolder"

   PathToMainFolder=$(jq -rc .Resources.PathToFolder.Path Account_Config.json)
   Step11_PathToFolder=("$PathToMainFolder""Step11_CreateGoldBackupPlanParams.json")
   if [ -z $PathToMainFolder ]; then
    echo "Path to main folder has not been setup. Please setup in Account_Config.json"  | tee -a Error_Log.txt
    exit 1
   fi

   # Input params for step 11
    echo "{" > "$Step11_PathToFolder"
   echo "\"VpcId"\"": "\"$VPC_Id"\"", | tee -a "$Step11_PathToFolder"
   echo "\"Description"\"": "\"Gold Backup Plan"\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"Parameters"\""": "{" | tee -a "$Step11_PathToFolder"
   echo "\"BackupPlanName"\"": "\"Gold Backup Plan"\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"ResourceTagKey"\"": "\"RPO"\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"ResourceTagValue"\"": "\"Gold"\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1Name"\"": "\"GoldBackupRule1"\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1Vault"\"": "\"ams-custom-backups"\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1CompletionWindowMinutes"\": 180 "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1DeleteAfterDays"\": 36 "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1MoveToColdStorageAfterDays"\": 15 "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1StartWindowMinutes"\": 60 "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1RecoveryPointTagKey"\"": "\""\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1RecoveryPointTagValue"\"": "\""\"" "," | tee -a "$Step11_PathToFolder"
   echo "\"BackupRule1ScheduleExpression"\"": "\""cron(0 10/4 ? * * *)"\""" | tee -a "$Step11_PathToFolder"
   echo "},"  | tee -a "$Step11_PathToFolder"
   echo "\"StackTemplateId\": ""\"stm-sc68a620000000000"\""," | tee -a "$Step11_PathToFolder"
   echo "\"TimeoutInMinutes\": 60," | tee -a "$Step11_PathToFolder"
   echo "\"Name\": \"TEST_STACK\"" | tee -a "$Step11_PathToFolder"
   echo "}"  | tee -a "$Step11_PathToFolder"

   AMS_RFC=$(aws amscm create-rfc --cli-input-json file://../JSON_Files/CreateBronzBackUpPlan.json  --execution-parameters file://../JSON_Files/Step09_CreateBronzeBackupPlanParams.json --output json)
   # Check if the length of the return is larger than 20 which means an RFC has been created.
   echo "$AMS_RFC" > RFC_ID_Temp.json
   AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)


   if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo " RFC created successfully for Bronz Backup plan"
      RFC_Status=(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
      if ( RFC_Status="Editing" ); then
        echo " Bronz Backup plan Ready for Submission"
        RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
        echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
        echo " RFC has been submitted to create Bronz Backup plan"
       fi
   fi

   if [ ${#AMS_RFC_ID} -le 20 ]; then
     echo " Bronz Backup plan Creation Failed, Exiting"  | tee -a Error_Log.txt
     exit 1
  fi


  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""/CreateSilverBackUpPlan.json"  --execution-parameters file://"$PathToMainFolder""/Step10_CreateSilverBackUpPlanParams.json" --output json)
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)
  # Check if the length of the return is larger than 20 which means an RFC has been created.
  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo " RFC created successfully for Silver Backup plan"
    RFC_Status=(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
    if ( RFC_Status="Editing" ); then
        echo " Silver Backup plan Ready for Submission"
        RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
        echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
        echo " RFC has been submitted for for Silver Backup plan"
    fi

  fi

  if [ ${#AMS_RFC} -le 20 ]; then
    echo " Silver Backup plan Creation Failed, Exiting"  | tee -a Error_Log.txt
    exit 1
  fi

  AMS_RFC=$(aws amscm create-rfc --cli-input-json file://"$PathToMainFolder""/CreateGoldBackUpPlan.json"  --execution-parameters file://"$PathToMainFolder""/Step11_CreateGoldBackupPlanParams.json" --output json)
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  # Check if the length of the return is larger than 20 which means an RFC has been created.
  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    echo " RFC created successfully for Gold Backup plan"
    RFC_Status=(aws amscm get-rfc --rfc-id $AMS_RFC_ID --output text)
    if ( RFC_Status="Editing" ); then
        echo " Gold Backup plan Ready for Submission"
        RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
        echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
        echo " RFC has been submitted for Gold Backup plan"
    fi
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo " RFC Creation Failed, Exiting"  | tee -a Error_Log.txt
    exit
  fi
  # Print last command status
  echo $?
