#!/usr/bin/env bash
  echo "********************************** Running Step 07,08 **********************************"
  # Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  # lookup the account ID
  DateTime=$(date '+%d/%m/%Y %H:%M:%S');
  Step_Name=$(basename -- "$0");

  Account_Id=$(jq -rc .Resources.AccountIds.AccountId Account_Config.json)
  if [ -z $Account_Id ]; then
     echo "Account ID lookup Failed"  | tee -a Error_Log.txt
    exit 1
  fi
  #### Provision Lambda  ####
  # File AMS RFC to provision self serv AWS service for Lambda
  AMS_RFC=$(aws amscm create-rfc --title Add-Self-Serve-Service-Lambda --change-type-id ct-3qe6io8t6jtny --change-type-version 1.0 --execution-parameters '{ "ServiceName": "AWS Lambda", "IAMRole":"arn:aws:iam::'$Account_Id':role/MultiServiceAdmin"}' --output json)
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  # Check if the length of the return is larger than 20 which means an RFC has been created.
  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    #Submit the RFC
    RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
    echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
    echo "Submitted RFC to on-board Lambda" | tee -a Account_Onboarding_Report.txt

    # Since this RFC requires AMS manual approval, this is the latest step in the Self Serv service
  fi
   echo $AMS_RFC_ID

  # File AMS RFC to provision self serv AWS service for Security HUB
  AMS_RFC=$(aws amscm create-rfc --title Add-Self-Serve-Service-Security-HUB --change-type-id ct-3qe6io8t6jtny --change-type-version 1.0 --execution-parameters '{ "ServiceName": "AWS Security Hub", "IAMRole":"arn:aws:iam::'$Account_Id':role/MultiServiceAdmin"}' --output json)
  #Check if the length of the return is larger than 20 which means an RFC has been created.
  echo "$AMS_RFC" > RFC_ID_Temp.json
  AMS_RFC_ID=$(jq -rc .RfcId RFC_ID_Temp.json)

  if [ ${#AMS_RFC_ID} -ge 20 ]; then
    RFC_Submit_Status=$(aws amscm submit-rfc --rfc-id $AMS_RFC_ID --output text)
    echo  $Step_Name "Ran account inflation on AMS managed account " "**"$Account_Id"**" "using RFC," "**"$AMS_RFC_ID"**" ",on" "**"$DateTime"**" | tee -a Account_Onboarding_Report.txt
    echo "Submitted RFC to on-board Security Hub" | tee -a Account_Onboarding_Report.txt
    echo \n
    #Since this RFC requires AMS approval, this is the latest step in the Self Serv service
  fi

  if [ ${#AMS_RFC_ID} -le 20 ]; then
    echo "AWS service for Security HUB RFC create failed , bailing out" | tee -a Error_Log.txt
    exit 1
  fi
  # Print last command status
  echo $?