#!/usr/bin/env bash
# Set e will force exit if any error happen or any thread returns other than 0 return
  set -e
  echo $PathToMainFolder
  Main_ScriptPathToFolder=("$PathToMainFolder""Shell_Scripts")
  echo $Main_ScriptPathToFolder

  # Master script to manage account inflation
  echo "Beginning account inflation"  | tee -a Account_Onboarding_Report.txt
  # Create cloudhealth role
  echo "Step 6 -- Creating Cloud Health Role" | tee -a Account_Onboarding_Report.txt
  sh ./Step_06_CreateCloudHealth.sh

  if [ $? -eq 0 ]
    then
    echo "Successfully Finished step 6" | tee -a Account_Onboarding_Report.txt
  else
    echo "Step 6 failed, exiting" | tee - a Error_log.txt
    exit 1
  fi

 #Create BackUp Plans, this includes steps 9,10 and 11
 echo "Step 9,10,11 -- Creating Backup Plans" | tee -a Account_Onboarding_Report.txt
 sh ./Step_09_CreateBackUpPlan.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 9" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 9 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 # Create KMS Key
 echo "Step 12 -- Creating KMS key" | tee -a Account_Onboarding_Report.txt
 sh ./Step_12_CreateKMSKey.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 12" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 12 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 # Raise MOO RFC to add KMS key policy to this custom SNS key
 echo "Step 13 -- Creating MOO RFC to add KMS key policy to this custom SNS key" | tee -a Account_Onboarding_Report.txt
 sh ./Step_13_Create_MOO_KMS_Key.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 13" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 13 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 # Create SNS Topic for Guard Duty
 echo "Step 14 -- Creating SNS topic for Guard duty" | tee -a Account_Onboarding_Report.txt
 sh ./Step_14_CreateSNSTopic.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 14 " | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 14 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 echo "Step 15 -- Raising MOO RFC to create CloudWatch Event Rule for GuardDuty Topic" | tee -a Account_Onboarding_Report.txt
 sh ./Step_15_Create_MOO_SNS_GD.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 15" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 15 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 # Raise MOO RFC to Setup Policy for SNS topic
 echo "Step 16 -- Raising MOO RFC to create CloudWatch Event Rule for GuardDuty Topic" | tee -a Account_Onboarding_Report.txt
 sh ./Step_16_Change_SNS_Topic_Policy.sh

 if [ $? -eq 0 ]
   then
   echo "Successfully Finished step 16" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 16 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 # Raise MOO RFC to setup SQS message
 echo "Step 17 -- Raising MOO RFC  to set up SQS queue permissions" | tee -a Account_Onboarding_Report.txt
 sh ./Step_17_Setup_SNS.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 17" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 17 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

 # Create SNS Topic for Config Rule
 echo "Step 18 -- Creating SNS topic for Config rule" | tee -a Account_Onboarding_Report.txt
 sh ./Step_18_Create_SNS_Config.sh

 if [ $? -eq 0 ]
 then
   echo "Successfully Finished step 18" | tee -a Account_Onboarding_Report.txt
 else
   echo "Step 18 failed, exiting" | tee - a Error_log.txt
   exit 1
 fi

  # Raise MOO RFC to Setup Policy for SNS topic
  echo "Step 19 -- Raising MOO RFC to update role for SNS topic , Config rule, permision" | tee -a Account_Onboarding_Report.txt
  sh ./Step_19_Update_SNS_Role.sh

  if [ $? -eq 0 ]
  then
    echo "Successfully Finished step 19" | tee -a Account_Onboarding_Report.txt
  else
    echo "Step 19 failed, exiting" | tee - a Error_log.txt
    exit 1
  fi

  # Step 20	Dependent on Step 18 and 19	Raise SR and attach AWS Config Rule CloudFormation Templates
  echo "Step 20 CFN template attachment for RFC ingestion for Config SNS subscription" | tee -a Account_Onboarding_Report.txt
  sh ./Step_20_Service_Request_Config_rule.sh

  if [ $? -eq 0 ]
  then
    echo "Successfully Finished step 34" | tee -a Account_Onboarding_Report.txt
  else
    echo "Step 20 failed, exiting" | tee - a Error_log.txt
    exit 1
  fi

  # Step 21	Dependent on Step 18 and 19 and 20	Raise MOO RFC to ingest CloudFormation from SR
  echo "Step 21	Raise MOO RFC to ingest CloudFormation from SR" | tee -a Account_Onboarding_Report.txt
  sh ./Step_21_Onboard_Config.sh

  if [ $? -eq 0 ]
  then
    echo "Successfully Finished step 21" | tee -a Account_Onboarding_Report.txt
  else
    echo "Step 21 failed, exiting" | tee - a Error_log.txt
    exit 1
  fi

  # Create SNS Topic for Config Rule
  echo "Step 34 -- Request to onboard account to patch orchestrator" | tee -a Account_Onboarding_Report.txt
  sh ./Step_34_Patch_Orchestrator_Service_Requests.sh

  if [ $? -eq 0 ]
  then
    echo "Successfully Finished step 34" | tee -a Account_Onboarding_Report.txt
  else
    echo "Step 34 failed, exiting" | tee - a Error_log.txt
    exit 1
  fi

    # Create SR to onboard MACIE
  echo "Step 37 -- Request to onboard account to Macie" | tee -a Account_Onboarding_Report.txt
  sh ./Step_37_Service_Request_Onboard_Macie.sh

  if [ $? -eq 0 ]
  then
    echo "Successfully Finished step 37" | tee -a Account_Onboarding_Report.txt
  else
    echo "Step 37 failed, exiting" | tee - a Error_log.txt
    exit 1
  fi





  Print last command status
 echo $?