Disclaimer:
The following set of scripts were built to enable faster application on-boarding process and have not
been fully tested or verified by AWS security. It is meant to illustrate how AMS automation
works but is not a fully developed product. Customers are encouraged to test and verify outcomes before using
on a production environment

Use case:
This script is built to enable AMS customers to automate 
Request For Change(RFC) process which governs AMS change mgmt process.  

AMS customers requesting new application accounts in MALZ will follow the initial account onboarding
with a set of RFC means to on-board and create roles, enable services to allow production readiness for
the on-boarded account

List of automated tasks: (Total 25 RFCs)
1- Create AMS MOO RFC ( x4)
2- Create IAM role and policy ( x1)
3- Create SNS topic ( x2)
4- Create KMS key ( x1)
6- Create BackupPlan (x3)
7- Create patch window ( x9)
8- Create SSPS Roles ( x3)
9- Create Service Requests( x2)

Setup:
If running on Windows, you will need to install Cygwin https://www.cygwin.com/ or another verified

1-  Install jq 
Windows: chocolatey install jq
Mac: brew install jq.

2- Ensure permissions are setup correctly on the files by running chmod 755 * inside the 
expanded directory

3- Ensure AWS CLI and AMS CLI are installed and operational


Usage:
1- Navigate to Shell_Scripts/Account_Config.JSON
2- Obtain temporary credentials for the account you want to run the scripts (Access key, Secret key
and token)

Note that to account_config.json and update the account info. The current version operates on an a single
account. Multiple account automation is still under development

You will also need to update the path to the JSON_Files folder

Navigate to  Day_1_Step_1_Automated.sh and verify all step. Steps can be turned on and off by
commenting the scripts

Day 2 script,Day_2_Need_Input_Automated.sh, is means to run patch on-boarding. This is done on a separate day because the patch orchestrator
takes a day to complete 

Run the script by sh Day_1_Step_1_Automated.sh

Script Organization:
- Scripts will run AMS CLI commands to create RFC record and then submit the RFC
- The RFC input is a JSON file named with the Step
- In some cases, the jSON is generated dynamically
- Account ID and VPC ID are dynamically added to the JSON from the Account_Config.json 

Known issues and manual steps:
- Step 20 requires attaching a file for the config rules, this step needs to be done manually. If the 
attachment is not done, AMS OPS will reject the SR


In progress
- Install via Docker
- Run scripts via Docker


Next steps:

- Support for multiple accounts 
- Support for multiple VPCs
 

