/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.manager;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultCompilerManager
implements CompilerManager {
    private static final String ERROR_MESSAGE = "Compiler '{}' could not be instantiated or injected properly. If you spelled the compiler ID correctly and all necessary dependencies are on the classpath, then next you can try running the build with -Dsisu.debug, looking for exceptions.";
    private static final String ERROR_MESSAGE_DETAIL = "TypeNotPresentException caused by UnsupportedClassVersionError might indicate, that the compiler needs a more recent Java runtime. IllegalArgumentException in ClassReader.<init> might mean, that you need to upgrade Maven.";
    @Inject
    private Map<String, Provider<Compiler>> compilers;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Compiler getCompiler(String compilerId) throws NoSuchCompilerException {
        Provider<Compiler> compilerProvider = this.compilers.get(compilerId);
        if (compilerProvider == null) {
            this.log.error("Compiler '{}' could not be instantiated or injected properly. If you spelled the compiler ID correctly and all necessary dependencies are on the classpath, then next you can try running the build with -Dsisu.debug, looking for exceptions. TypeNotPresentException caused by UnsupportedClassVersionError might indicate, that the compiler needs a more recent Java runtime. IllegalArgumentException in ClassReader.<init> might mean, that you need to upgrade Maven.", (Object)compilerId);
            throw new NoSuchCompilerException(compilerId);
        }
        try {
            return (Compiler)compilerProvider.get();
        }
        catch (Exception e) {
            this.log.error(ERROR_MESSAGE, (Object)compilerId);
            throw new NoSuchCompilerException(compilerId, e);
        }
    }
}

