/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Singleton
@Named
public class DefaultMavenResourcesFiltering
implements MavenResourcesFiltering {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMavenResourcesFiltering.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private final List<String> defaultNonFilteredFileExtensions;
    private final MavenFileFilter mavenFileFilter;
    private final BuildContext buildContext;

    @Inject
    public DefaultMavenResourcesFiltering(MavenFileFilter mavenFileFilter, BuildContext buildContext) {
        this.mavenFileFilter = Objects.requireNonNull(mavenFileFilter);
        this.buildContext = Objects.requireNonNull(buildContext);
        this.defaultNonFilteredFileExtensions = new ArrayList<String>(5);
        this.defaultNonFilteredFileExtensions.add("jpg");
        this.defaultNonFilteredFileExtensions.add("jpeg");
        this.defaultNonFilteredFileExtensions.add("gif");
        this.defaultNonFilteredFileExtensions.add("bmp");
        this.defaultNonFilteredFileExtensions.add("png");
        this.defaultNonFilteredFileExtensions.add("ico");
    }

    @Override
    public boolean filteredFileExtension(String fileName, List<String> userNonFilteredFileExtensions) {
        String extension;
        boolean filteredFileExtension;
        ArrayList<String> nonFilteredFileExtensions = new ArrayList<String>(this.getDefaultNonFilteredFileExtensions());
        if (userNonFilteredFileExtensions != null) {
            nonFilteredFileExtensions.addAll(userNonFilteredFileExtensions);
        }
        boolean bl = filteredFileExtension = !nonFilteredFileExtensions.contains(extension = DefaultMavenResourcesFiltering.getExtension(fileName));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("file " + fileName + " has a" + (filteredFileExtension ? " " : " non ") + "filtered file extension");
        }
        return filteredFileExtension;
    }

    private static String getExtension(String fileName) {
        String rawExt = FilenameUtils.getExtension((String)fileName);
        return rawExt == null ? null : rawExt.toLowerCase(Locale.ROOT);
    }

    @Override
    public List<String> getDefaultNonFilteredFileExtensions() {
        return this.defaultNonFilteredFileExtensions;
    }

    @Override
    public void filterResources(final MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        if (mavenResourcesExecution == null) {
            throw new MavenFilteringException("mavenResourcesExecution cannot be null");
        }
        if (mavenResourcesExecution.getResources() == null) {
            LOGGER.info("No resources configured skip copying/filtering");
            return;
        }
        if (mavenResourcesExecution.getOutputDirectory() == null) {
            throw new MavenFilteringException("outputDirectory cannot be null");
        }
        if (mavenResourcesExecution.isUseDefaultFilterWrappers()) {
            this.handleDefaultFilterWrappers(mavenResourcesExecution);
        }
        if (mavenResourcesExecution.getEncoding() == null || mavenResourcesExecution.getEncoding().length() < 1) {
            LOGGER.warn("Using platform encoding (" + System.getProperty("file.encoding") + " actually) to copy filtered resources, i.e. build is platform dependent!");
        } else {
            LOGGER.debug("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered resources.");
        }
        if (mavenResourcesExecution.getPropertiesEncoding() == null || mavenResourcesExecution.getPropertiesEncoding().length() < 1) {
            LOGGER.debug("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered properties files.");
        } else {
            LOGGER.debug("Using '" + mavenResourcesExecution.getPropertiesEncoding() + "' encoding to copy filtered properties files.");
        }
        boolean isFilteringUsed = false;
        ArrayList<File> propertiesFiles = new ArrayList<File>();
        for (Resource resource : mavenResourcesExecution.getResources()) {
            File resourceDirectory;
            if (LOGGER.isDebugEnabled()) {
                String ls = System.lineSeparator();
                StringBuilder debugMessage = new StringBuilder("resource with targetPath ").append(resource.getTargetPath()).append(ls);
                debugMessage.append("directory ").append(resource.getDirectory()).append(ls);
                debugMessage.append("excludes ").append(resource.getExcludes() == null ? " empty " : resource.getExcludes().toString()).append(ls);
                debugMessage.append("includes ").append(resource.getIncludes() == null ? " empty " : resource.getIncludes().toString());
                LOGGER.debug(debugMessage.toString());
            }
            final String targetPath = resource.getTargetPath();
            File file = resourceDirectory = resource.getDirectory() == null ? null : new File(resource.getDirectory());
            if (resourceDirectory != null && !resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(mavenResourcesExecution.getResourcesBaseDirectory(), resourceDirectory.getPath());
            }
            if (resourceDirectory == null || !resourceDirectory.exists()) {
                LOGGER.info("skip non existing resourceDirectory " + resourceDirectory);
                continue;
            }
            final File outputDirectory = mavenResourcesExecution.getOutputDirectory();
            if (!outputDirectory.mkdirs() && !outputDirectory.exists()) {
                throw new MavenFilteringException("Cannot create resource output directory: " + outputDirectory);
            }
            if (resource.isFiltering()) {
                isFilteringUsed = true;
            }
            final boolean filtersFileChanged = this.buildContext.hasDelta(mavenResourcesExecution.getFileFilters());
            final Path resourcePath = resourceDirectory.toPath();
            DirectoryScanner scanner = new DirectoryScanner(){

                protected boolean isSelected(String name, File file) {
                    if (filtersFileChanged) {
                        return true;
                    }
                    if (file.isFile()) {
                        try {
                            File targetFile = this.getTargetFile(file);
                            if (targetFile.isFile() && DefaultMavenResourcesFiltering.this.buildContext.isUptodate(targetFile, file)) {
                                return false;
                            }
                        }
                        catch (MavenFilteringException mavenFilteringException) {
                            // empty catch block
                        }
                    }
                    return true;
                }

                private File getTargetFile(File file) throws MavenFilteringException {
                    Path relativize = resourcePath.relativize(file.toPath());
                    return DefaultMavenResourcesFiltering.this.getDestinationFile(outputDirectory, targetPath, relativize.toString(), mavenResourcesExecution);
                }
            };
            scanner.setBasedir(resourceDirectory);
            this.setupScanner(resource, (Scanner)scanner, mavenResourcesExecution.isAddDefaultExcludes());
            scanner.scan();
            if (mavenResourcesExecution.isIncludeEmptyDirs()) {
                try {
                    File targetDirectory = targetPath == null ? outputDirectory : new File(outputDirectory, targetPath);
                    this.copyDirectoryLayout(resourceDirectory, targetDirectory, (Scanner)scanner);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Cannot copy directory structure from " + resourceDirectory.getPath() + " to " + outputDirectory.getPath());
                }
            }
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            try {
                Path basedir = mavenResourcesExecution.getMavenProject().getBasedir().getAbsoluteFile().toPath();
                Path destination = this.getDestinationFile(outputDirectory, targetPath, "", mavenResourcesExecution).getAbsoluteFile().toPath();
                String origin = basedir.relativize(resourceDirectory.getAbsoluteFile().toPath()).toString();
                if (StringUtils.isEmpty((CharSequence)origin)) {
                    origin = ".";
                }
                LOGGER.info("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + " from " + origin + " to " + basedir.relativize(destination));
            }
            catch (Exception e) {
                LOGGER.info("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath));
            }
            for (String name : includedFiles) {
                LOGGER.debug("Copying file " + name);
                File source = new File(resourceDirectory, name);
                File destinationFile = this.getDestinationFile(outputDirectory, targetPath, name, mavenResourcesExecution);
                if (mavenResourcesExecution.isFlatten() && destinationFile.exists()) {
                    if (mavenResourcesExecution.isOverwrite()) {
                        LOGGER.warn("existing file " + destinationFile.getName() + " will be overwritten by " + name);
                    } else {
                        throw new MavenFilteringException("existing file " + destinationFile.getName() + " will be overwritten by " + name + " and overwrite was not set to true");
                    }
                }
                boolean filteredExt = this.filteredFileExtension(source.getName(), mavenResourcesExecution.getNonFilteredFileExtensions());
                if (resource.isFiltering() && DefaultMavenResourcesFiltering.isPropertiesFile(source)) {
                    propertiesFiles.add(source);
                }
                String encoding = DefaultMavenResourcesFiltering.getEncoding(source, mavenResourcesExecution.getEncoding(), mavenResourcesExecution.getPropertiesEncoding());
                LOGGER.debug("Using '" + encoding + "' encoding to copy filtered resource '" + source.getName() + "'.");
                this.mavenFileFilter.copyFile(source, destinationFile, resource.isFiltering() && filteredExt, mavenResourcesExecution.getFilterWrappers(), encoding, mavenResourcesExecution.isOverwrite());
            }
            Scanner deleteScanner = this.buildContext.newDeleteScanner(resourceDirectory);
            this.setupScanner(resource, deleteScanner, mavenResourcesExecution.isAddDefaultExcludes());
            deleteScanner.scan();
            for (String name : deleteScanner.getIncludedFiles()) {
                File destinationFile = this.getDestinationFile(outputDirectory, targetPath, name, mavenResourcesExecution);
                destinationFile.delete();
                this.buildContext.refresh(destinationFile);
            }
        }
        if ((mavenResourcesExecution.getPropertiesEncoding() == null || mavenResourcesExecution.getPropertiesEncoding().length() < 1) && !mavenResourcesExecution.getNonFilteredFileExtensions().contains("properties") && isFilteringUsed && propertiesFiles.size() > 0) {
            LOGGER.info("The encoding used to copy filtered properties files has not been set. This means that the same encoding will be used to copy filtered properties files as when copying other filtered resources. This might not be what you want! Run your build with --debug to see which files might be affected. Read more at https://maven.apache.org/plugins/maven-resources-plugin/examples/filtering-properties-files.html");
            StringBuilder affectedFiles = new StringBuilder();
            affectedFiles.append("Here is a list of the filtered properties files in your project that might be affected by encoding problems: ");
            for (File propertiesFile : propertiesFiles) {
                affectedFiles.append(System.lineSeparator()).append(" - ").append(propertiesFile.getPath());
            }
            LOGGER.debug(affectedFiles.toString());
        }
    }

    static String getEncoding(File file, String encoding, String propertiesEncoding) {
        if (DefaultMavenResourcesFiltering.isPropertiesFile(file)) {
            if (propertiesEncoding == null) {
                return encoding;
            }
            return propertiesEncoding;
        }
        return encoding;
    }

    static boolean isPropertiesFile(File file) {
        return "properties".equals(DefaultMavenResourcesFiltering.getExtension(file.getName()));
    }

    private void handleDefaultFilterWrappers(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        ArrayList<FilterWrapper> filterWrappers = new ArrayList<FilterWrapper>();
        if (mavenResourcesExecution.getFilterWrappers() != null) {
            filterWrappers.addAll(mavenResourcesExecution.getFilterWrappers());
        }
        filterWrappers.addAll(this.mavenFileFilter.getDefaultFilterWrappers(mavenResourcesExecution));
        mavenResourcesExecution.setFilterWrappers(filterWrappers);
    }

    private File getDestinationFile(File outputDirectory, String targetPath, String name, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        File destinationFile;
        String destination;
        if (!mavenResourcesExecution.isFlatten()) {
            destination = name;
        } else {
            Path path = Paths.get(name, new String[0]);
            Path filePath = path.getFileName();
            destination = filePath.toString();
        }
        if (mavenResourcesExecution.isFilterFilenames() && mavenResourcesExecution.getFilterWrappers().size() > 0) {
            destination = this.filterFileName(destination, mavenResourcesExecution.getFilterWrappers());
        }
        if (targetPath != null) {
            destination = targetPath + "/" + destination;
        }
        if (!(destinationFile = new File(destination)).isAbsolute()) {
            destinationFile = new File(outputDirectory, destination);
        }
        if (!destinationFile.getParentFile().exists()) {
            destinationFile.getParentFile().mkdirs();
        }
        return destinationFile;
    }

    private String[] setupScanner(Resource resource, Scanner scanner, boolean addDefaultExcludes) {
        String[] includes = resource.getIncludes() != null && !resource.getIncludes().isEmpty() ? resource.getIncludes().toArray(EMPTY_STRING_ARRAY) : DEFAULT_INCLUDES;
        scanner.setIncludes(includes);
        String[] excludes = null;
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            excludes = resource.getExcludes().toArray(EMPTY_STRING_ARRAY);
            scanner.setExcludes(excludes);
        }
        if (addDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        return includes;
    }

    private void copyDirectoryLayout(File sourceDirectory, File destinationDirectory, Scanner scanner) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exist (" + sourceDirectory.getAbsolutePath() + ").");
        }
        for (String name : scanner.getIncludedDirectories()) {
            File source = new File(sourceDirectory, name);
            if (source.equals(sourceDirectory)) continue;
            File destination = new File(destinationDirectory, name);
            destination.mkdirs();
        }
    }

    private String getRelativeOutputDirectory(MavenResourcesExecution execution) {
        String relOutDir = execution.getOutputDirectory().getAbsolutePath();
        if (execution.getMavenProject() != null && execution.getMavenProject().getBasedir() != null) {
            String basedir = execution.getMavenProject().getBasedir().getAbsolutePath();
            relOutDir = FilteringUtils.getRelativeFilePath(basedir, relOutDir);
            relOutDir = relOutDir == null ? execution.getOutputDirectory().getPath() : relOutDir.replace('\\', '/');
        }
        return relOutDir;
    }

    private String filterFileName(String name, List<FilterWrapper> wrappers) throws MavenFilteringException {
        String string;
        Reader reader = new StringReader(name);
        for (FilterWrapper wrapper : wrappers) {
            reader = wrapper.getReader(reader);
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((Reader)reader, (Writer)writer);
            String filteredFilename = writer.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("renaming filename " + name + " to " + filteredFilename);
            }
            string = filteredFilename;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MavenFilteringException("Failed filtering filename" + name, e);
            }
        }
        writer.close();
        return string;
    }
}

