/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import javax.inject.Named;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipResource;
import org.codehaus.plexus.archiver.zip.ZipSymlinkResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.EncodingSupported;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

@Named(value="zip")
public class PlexusArchiverZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements EncodingSupported {
    private Charset charset = StandardCharsets.UTF_8;

    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        ZipFile zipFile = new ZipFile(f, this.charset != null ? this.charset.name() : "UTF8");
        return new CloseableIterator(zipFile);
    }

    public boolean isConcurrentAccessSupported() {
        return false;
    }

    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    class CloseableIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        final Enumeration<ZipArchiveEntry> en;
        private final ZipFile zipFile;

        public CloseableIterator(ZipFile zipFile) {
            this.en = zipFile.getEntriesInPhysicalOrder();
            this.zipFile = zipFile;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipArchiveEntry entry = this.en.nextElement();
            return entry.isUnixSymlink() ? new ZipSymlinkResource(this.zipFile, entry, PlexusArchiverZipFileResourceCollection.this.getStreamTransformer()) : new ZipResource(this.zipFile, entry, PlexusArchiverZipFileResourceCollection.this.getStreamTransformer());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

