﻿using System;
using System.Linq;
using System.Threading.Tasks;
using Amazon.Runtime;
using Amazon.SQS;
using Amazon.SQS.Model;

namespace SqsTestApp
{
    class Program
    {
        const string queueUrl = "https://sqs.us-east-1.amazonaws.com/<AwsAccountId>/sqstestqueue"; //This would come from config file

        //Create a client to talk to SQS
        static AmazonSQSClient amazonSqsClient = new AmazonSQSClient(Amazon.RegionEndpoint.USEast1);

        static void Main(string[] args)
        {
            MainAsync().GetAwaiter().GetResult();
            Console.ReadKey();
        }

        static async Task MainAsync()
        {
            Console.WriteLine("Queue Test Starting!");
            
            await SendMessagesAsync(10);

        }

        static async Task SendMessagesAsync(int numberOfMessagesToSend)
        {
            Console.WriteLine("Creating Client and request");
           
            try
            {
                for (var i = 0; i < numberOfMessagesToSend; i++)
                {
                    //Create the request to send
                    var sendRequest = new SendMessageRequest {QueueUrl = queueUrl, MessageBody = $"Message {i}"};

                    //Send the message to the queue and wait for the result
                    Console.WriteLine("Sending Message");
                    var sendMessageResponse = amazonSqsClient.SendMessageAsync(sendRequest).Result;
                }
            }
            catch (Exception exception)
            {
                Console.WriteLine($"{DateTime.Now} :: Exception: {exception.Message}");
            }
            
        }
    }
}
