﻿using System;
using System.Linq;
using System.Threading.Tasks;
using Amazon.Runtime;
using Amazon.SQS;
using Amazon.SQS.Model;

namespace SqsMessageReceiver
{
    class Program
    {
        const string queueUrl = "https://sqs.us-east-1.amazonaws.com/<AwsAccountId>/testqueue"; //This would come from config file
        //Create a client to talk to SQS
        static AmazonSQSClient amazonSqsClient = new AmazonSQSClient(Amazon.RegionEndpoint.USEast1);

        static void Main(string[] args)
        {
            MainAsync().GetAwaiter().GetResult();
            Console.ReadKey();
        }

        static async Task MainAsync()
        {
            Console.WriteLine("Receiving Message");

            //Create a receive request to see if there are any messages on the queue
            var receiveMessageRequest = new ReceiveMessageRequest();
            receiveMessageRequest.MaxNumberOfMessages = 10;
            receiveMessageRequest.QueueUrl = queueUrl;

            //Send the receive request and wait for the response
            var response = amazonSqsClient.ReceiveMessageAsync(receiveMessageRequest).Result;

            do
            {
                foreach (var message in response.Messages)
                {
                    //Spit it out
                    Console.WriteLine(message.Body);

                    //Remove it from the queue as we don't want to see it again
                    var deleteMessageRequest = new DeleteMessageRequest
                    {
                        QueueUrl = queueUrl, ReceiptHandle = message.ReceiptHandle
                    };

                    var result = amazonSqsClient.DeleteMessageAsync(deleteMessageRequest).Result;
                }

                response = amazonSqsClient.ReceiveMessageAsync(receiveMessageRequest).Result;
            } while (response.Messages.Any());

        }
    }
}
