import cv2

class OpenCVRTSPStream:
    def __init__(self, rtsp_url, width=800, height=600):
        print("OpenCV RTSP Stream object init.")
        self.initialized = False
        self.rtsp_url = rtsp_url
        self.width = width
        self.height = height

        self.__init_rtsp_stream()

    def get(self):
        return self.__get_next_frame()
    
    def __init_rtsp_stream(self):
        if self.initialized:
            # release any resources
            self.cap.release()
            self.initialized = False

        # Setup the capture interface
        self.cap = cv2.VideoCapture(self.rtsp_url)
        print(f"Opened stream, resolution is: {int(self.cap.get(cv2.CAP_PROP_FRAME_WIDTH))}x{int(self.cap.get(cv2.CAP_PROP_FRAME_HEIGHT))} and a frame rate of {self.cap.get(cv2.CAP_PROP_FPS)}")

        self.initialized = True


    def __get_next_frame(self):
        while True:
            ret, frame = self.cap.read()
            if ret:
                if self.width > 0 and self.height > 0:
                    frame = cv2.resize(frame, (self.width, self.height))
                return frame
            else:
                print("Failed to get frame. Let's try to re-initialize the stream.")
                self.__init_rtsp_stream()


class OpenCVApp:
    def __init__(self, rtsp_url):
        print("OpenCVApp init.")
        self.video_in = OpenCVRTSPStream(rtsp_url)