<?php
// This file was auto-generated from sdk-root/src/data/trustedadvisor/2022-09-15/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2022-09-15', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'trustedadvisor', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'TrustedAdvisor Public API', 'serviceId' => 'TrustedAdvisor', 'signatureVersion' => 'v4', 'signingName' => 'trustedadvisor', 'uid' => 'trustedadvisor-2022-09-15', ], 'operations' => [ 'BatchUpdateRecommendationResourceExclusion' => [ 'name' => 'BatchUpdateRecommendationResourceExclusion', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/batch-update-recommendation-resource-exclusion', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchUpdateRecommendationResourceExclusionRequest', ], 'output' => [ 'shape' => 'BatchUpdateRecommendationResourceExclusionResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'GetOrganizationRecommendation' => [ 'name' => 'GetOrganizationRecommendation', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/organization-recommendations/{organizationRecommendationIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOrganizationRecommendationRequest', ], 'output' => [ 'shape' => 'GetOrganizationRecommendationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetRecommendation' => [ 'name' => 'GetRecommendation', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/recommendations/{recommendationIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRecommendationRequest', ], 'output' => [ 'shape' => 'GetRecommendationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListChecks' => [ 'name' => 'ListChecks', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/checks', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChecksRequest', ], 'output' => [ 'shape' => 'ListChecksResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], ], 'readonly' => true, ], 'ListOrganizationRecommendationAccounts' => [ 'name' => 'ListOrganizationRecommendationAccounts', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/organization-recommendations/{organizationRecommendationIdentifier}/accounts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOrganizationRecommendationAccountsRequest', ], 'output' => [ 'shape' => 'ListOrganizationRecommendationAccountsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListOrganizationRecommendationResources' => [ 'name' => 'ListOrganizationRecommendationResources', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/organization-recommendations/{organizationRecommendationIdentifier}/resources', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOrganizationRecommendationResourcesRequest', ], 'output' => [ 'shape' => 'ListOrganizationRecommendationResourcesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListOrganizationRecommendations' => [ 'name' => 'ListOrganizationRecommendations', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/organization-recommendations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOrganizationRecommendationsRequest', ], 'output' => [ 'shape' => 'ListOrganizationRecommendationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], ], 'readonly' => true, ], 'ListRecommendationResources' => [ 'name' => 'ListRecommendationResources', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/recommendations/{recommendationIdentifier}/resources', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRecommendationResourcesRequest', ], 'output' => [ 'shape' => 'ListRecommendationResourcesResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListRecommendations' => [ 'name' => 'ListRecommendations', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/recommendations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRecommendationsRequest', ], 'output' => [ 'shape' => 'ListRecommendationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], ], 'readonly' => true, ], 'UpdateOrganizationRecommendationLifecycle' => [ 'name' => 'UpdateOrganizationRecommendationLifecycle', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/organization-recommendations/{organizationRecommendationIdentifier}/lifecycle', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateOrganizationRecommendationLifecycleRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateRecommendationLifecycle' => [ 'name' => 'UpdateRecommendationLifecycle', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/recommendations/{recommendationIdentifier}/lifecycle', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateRecommendationLifecycleRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d+', ], 'AccountRecommendationArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor::\\d{12}:recommendation\\/[\\w-]+', ], 'AccountRecommendationIdentifier' => [ 'type' => 'string', 'max' => 200, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor::\\d{12}:recommendation\\/[\\w-]+', ], 'AccountRecommendationLifecycleSummary' => [ 'type' => 'structure', 'members' => [ 'accountId' => [ 'shape' => 'AccountId', ], 'accountRecommendationArn' => [ 'shape' => 'AccountRecommendationArn', ], 'lifecycleStage' => [ 'shape' => 'RecommendationLifecycleStage', ], 'updatedOnBehalfOf' => [ 'shape' => 'String', ], 'updatedOnBehalfOfJobTitle' => [ 'shape' => 'String', ], 'updateReason' => [ 'shape' => 'RecommendationUpdateReason', ], 'updateReasonCode' => [ 'shape' => 'UpdateRecommendationLifecycleStageReasonCode', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'AccountRecommendationLifecycleSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountRecommendationLifecycleSummary', ], ], 'BatchUpdateRecommendationResourceExclusionRequest' => [ 'type' => 'structure', 'required' => [ 'recommendationResourceExclusions', ], 'members' => [ 'recommendationResourceExclusions' => [ 'shape' => 'RecommendationResourceExclusionList', ], ], ], 'BatchUpdateRecommendationResourceExclusionResponse' => [ 'type' => 'structure', 'required' => [ 'batchUpdateRecommendationResourceExclusionErrors', ], 'members' => [ 'batchUpdateRecommendationResourceExclusionErrors' => [ 'shape' => 'UpdateRecommendationResourceExclusionErrorList', ], ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'CheckArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor:::check\\/[\\w-]+', ], 'CheckIdentifier' => [ 'type' => 'string', 'max' => 64, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor:::check\\/[\\w-]+', ], 'CheckSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'name', 'description', 'pillars', 'awsServices', 'source', 'metadata', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'arn' => [ 'shape' => 'CheckArn', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'pillars' => [ 'shape' => 'RecommendationPillarList', ], 'awsServices' => [ 'shape' => 'RecommendationAwsServiceList', ], 'source' => [ 'shape' => 'RecommendationSource', ], 'metadata' => [ 'shape' => 'StringMap', ], ], ], 'CheckSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CheckSummary', ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'ExclusionStatus' => [ 'type' => 'string', 'enum' => [ 'excluded', 'included', ], ], 'GetOrganizationRecommendationRequest' => [ 'type' => 'structure', 'required' => [ 'organizationRecommendationIdentifier', ], 'members' => [ 'organizationRecommendationIdentifier' => [ 'shape' => 'OrganizationRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'organizationRecommendationIdentifier', ], ], ], 'GetOrganizationRecommendationResponse' => [ 'type' => 'structure', 'members' => [ 'organizationRecommendation' => [ 'shape' => 'OrganizationRecommendation', ], ], ], 'GetRecommendationRequest' => [ 'type' => 'structure', 'required' => [ 'recommendationIdentifier', ], 'members' => [ 'recommendationIdentifier' => [ 'shape' => 'AccountRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'recommendationIdentifier', ], 'language' => [ 'shape' => 'RecommendationLanguage', 'location' => 'querystring', 'locationName' => 'language', ], ], ], 'GetRecommendationResponse' => [ 'type' => 'structure', 'members' => [ 'recommendation' => [ 'shape' => 'Recommendation', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'ListChecksRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'ListChecksRequestNextTokenString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListChecksRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'pillar' => [ 'shape' => 'RecommendationPillar', 'location' => 'querystring', 'locationName' => 'pillar', ], 'awsService' => [ 'shape' => 'RecommendationAwsService', 'location' => 'querystring', 'locationName' => 'awsService', ], 'source' => [ 'shape' => 'RecommendationSource', 'location' => 'querystring', 'locationName' => 'source', ], 'language' => [ 'shape' => 'RecommendationLanguage', 'location' => 'querystring', 'locationName' => 'language', ], ], ], 'ListChecksRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 200, 'min' => 1, ], 'ListChecksRequestNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListChecksResponse' => [ 'type' => 'structure', 'required' => [ 'checkSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListChecksResponseNextTokenString', ], 'checkSummaries' => [ 'shape' => 'CheckSummaryList', ], ], ], 'ListChecksResponseNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListOrganizationRecommendationAccountsRequest' => [ 'type' => 'structure', 'required' => [ 'organizationRecommendationIdentifier', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListOrganizationRecommendationAccountsRequestNextTokenString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListOrganizationRecommendationAccountsRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'organizationRecommendationIdentifier' => [ 'shape' => 'OrganizationRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'organizationRecommendationIdentifier', ], 'affectedAccountId' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'affectedAccountId', ], ], ], 'ListOrganizationRecommendationAccountsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 200, 'min' => 1, ], 'ListOrganizationRecommendationAccountsRequestNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListOrganizationRecommendationAccountsResponse' => [ 'type' => 'structure', 'required' => [ 'accountRecommendationLifecycleSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListOrganizationRecommendationAccountsResponseNextTokenString', ], 'accountRecommendationLifecycleSummaries' => [ 'shape' => 'AccountRecommendationLifecycleSummaryList', ], ], ], 'ListOrganizationRecommendationAccountsResponseNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListOrganizationRecommendationResourcesRequest' => [ 'type' => 'structure', 'required' => [ 'organizationRecommendationIdentifier', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListOrganizationRecommendationResourcesRequestNextTokenString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListOrganizationRecommendationResourcesRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'status' => [ 'shape' => 'ResourceStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'exclusionStatus' => [ 'shape' => 'ExclusionStatus', 'location' => 'querystring', 'locationName' => 'exclusionStatus', ], 'regionCode' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'regionCode', ], 'organizationRecommendationIdentifier' => [ 'shape' => 'OrganizationRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'organizationRecommendationIdentifier', ], 'affectedAccountId' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'affectedAccountId', ], ], ], 'ListOrganizationRecommendationResourcesRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 200, 'min' => 1, ], 'ListOrganizationRecommendationResourcesRequestNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListOrganizationRecommendationResourcesResponse' => [ 'type' => 'structure', 'required' => [ 'organizationRecommendationResourceSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListOrganizationRecommendationResourcesResponseNextTokenString', ], 'organizationRecommendationResourceSummaries' => [ 'shape' => 'OrganizationRecommendationResourceSummaryList', ], ], ], 'ListOrganizationRecommendationResourcesResponseNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListOrganizationRecommendationsRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'ListOrganizationRecommendationsRequestNextTokenString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListOrganizationRecommendationsRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'type' => [ 'shape' => 'RecommendationType', 'location' => 'querystring', 'locationName' => 'type', ], 'status' => [ 'shape' => 'RecommendationStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'pillar' => [ 'shape' => 'RecommendationPillar', 'location' => 'querystring', 'locationName' => 'pillar', ], 'awsService' => [ 'shape' => 'RecommendationAwsService', 'location' => 'querystring', 'locationName' => 'awsService', ], 'source' => [ 'shape' => 'RecommendationSource', 'location' => 'querystring', 'locationName' => 'source', ], 'checkIdentifier' => [ 'shape' => 'CheckIdentifier', 'location' => 'querystring', 'locationName' => 'checkIdentifier', ], 'afterLastUpdatedAt' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'afterLastUpdatedAt', ], 'beforeLastUpdatedAt' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'beforeLastUpdatedAt', ], ], ], 'ListOrganizationRecommendationsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 200, 'min' => 1, ], 'ListOrganizationRecommendationsRequestNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListOrganizationRecommendationsResponse' => [ 'type' => 'structure', 'required' => [ 'organizationRecommendationSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListOrganizationRecommendationsResponseNextTokenString', ], 'organizationRecommendationSummaries' => [ 'shape' => 'OrganizationRecommendationSummaryList', ], ], ], 'ListOrganizationRecommendationsResponseNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListRecommendationResourcesRequest' => [ 'type' => 'structure', 'required' => [ 'recommendationIdentifier', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListRecommendationResourcesRequestNextTokenString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListRecommendationResourcesRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'status' => [ 'shape' => 'ResourceStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'exclusionStatus' => [ 'shape' => 'ExclusionStatus', 'location' => 'querystring', 'locationName' => 'exclusionStatus', ], 'regionCode' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'regionCode', ], 'recommendationIdentifier' => [ 'shape' => 'AccountRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'recommendationIdentifier', ], 'language' => [ 'shape' => 'RecommendationLanguage', 'location' => 'querystring', 'locationName' => 'language', ], ], ], 'ListRecommendationResourcesRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 5000, 'min' => 1, ], 'ListRecommendationResourcesRequestNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListRecommendationResourcesResponse' => [ 'type' => 'structure', 'required' => [ 'recommendationResourceSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListRecommendationResourcesResponseNextTokenString', ], 'recommendationResourceSummaries' => [ 'shape' => 'RecommendationResourceSummaryList', ], ], ], 'ListRecommendationResourcesResponseNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListRecommendationsRequest' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'ListRecommendationsRequestNextTokenString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'ListRecommendationsRequestMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'type' => [ 'shape' => 'RecommendationType', 'location' => 'querystring', 'locationName' => 'type', ], 'status' => [ 'shape' => 'RecommendationStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'pillar' => [ 'shape' => 'RecommendationPillar', 'location' => 'querystring', 'locationName' => 'pillar', ], 'awsService' => [ 'shape' => 'RecommendationAwsService', 'location' => 'querystring', 'locationName' => 'awsService', ], 'source' => [ 'shape' => 'RecommendationSource', 'location' => 'querystring', 'locationName' => 'source', ], 'checkIdentifier' => [ 'shape' => 'CheckIdentifier', 'location' => 'querystring', 'locationName' => 'checkIdentifier', ], 'afterLastUpdatedAt' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'afterLastUpdatedAt', ], 'beforeLastUpdatedAt' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'beforeLastUpdatedAt', ], 'language' => [ 'shape' => 'RecommendationLanguage', 'location' => 'querystring', 'locationName' => 'language', ], ], ], 'ListRecommendationsRequestMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 200, 'min' => 1, ], 'ListRecommendationsRequestNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'ListRecommendationsResponse' => [ 'type' => 'structure', 'required' => [ 'recommendationSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'ListRecommendationsResponseNextTokenString', ], 'recommendationSummaries' => [ 'shape' => 'RecommendationSummaryList', ], ], ], 'ListRecommendationsResponseNextTokenString' => [ 'type' => 'string', 'max' => 10000, 'min' => 4, ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'OrganizationRecommendation' => [ 'type' => 'structure', 'required' => [ 'id', 'type', 'status', 'pillars', 'source', 'name', 'resourcesAggregates', 'arn', 'description', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'RecommendationType', ], 'checkArn' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'RecommendationStatus', ], 'lifecycleStage' => [ 'shape' => 'RecommendationLifecycleStage', ], 'pillars' => [ 'shape' => 'RecommendationPillarList', ], 'source' => [ 'shape' => 'RecommendationSource', ], 'awsServices' => [ 'shape' => 'RecommendationAwsServiceList', ], 'name' => [ 'shape' => 'String', ], 'resourcesAggregates' => [ 'shape' => 'RecommendationResourcesAggregates', ], 'pillarSpecificAggregates' => [ 'shape' => 'RecommendationPillarSpecificAggregates', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'arn' => [ 'shape' => 'OrganizationRecommendationArn', ], 'description' => [ 'shape' => 'String', ], 'createdBy' => [ 'shape' => 'String', ], 'updatedOnBehalfOf' => [ 'shape' => 'String', ], 'updatedOnBehalfOfJobTitle' => [ 'shape' => 'String', ], 'updateReason' => [ 'shape' => 'RecommendationUpdateReason', ], 'updateReasonCode' => [ 'shape' => 'UpdateRecommendationLifecycleStageReasonCode', ], 'resolvedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'OrganizationRecommendationArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor:::organization-recommendation\\/[\\w-]+', ], 'OrganizationRecommendationIdentifier' => [ 'type' => 'string', 'max' => 200, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor:::organization-recommendation\\/[\\w-]+', ], 'OrganizationRecommendationResourceSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'awsResourceId', 'regionCode', 'status', 'metadata', 'lastUpdatedAt', 'recommendationArn', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'arn' => [ 'shape' => 'RecommendationResourceArn', ], 'awsResourceId' => [ 'shape' => 'String', ], 'regionCode' => [ 'shape' => 'RecommendationRegionCode', ], 'status' => [ 'shape' => 'ResourceStatus', ], 'metadata' => [ 'shape' => 'StringMap', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'exclusionStatus' => [ 'shape' => 'ExclusionStatus', ], 'accountId' => [ 'shape' => 'AccountId', ], 'recommendationArn' => [ 'shape' => 'OrganizationRecommendationArn', ], ], ], 'OrganizationRecommendationResourceSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'OrganizationRecommendationResourceSummary', ], ], 'OrganizationRecommendationSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'type', 'status', 'pillars', 'source', 'name', 'resourcesAggregates', 'arn', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'RecommendationType', ], 'checkArn' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'RecommendationStatus', ], 'lifecycleStage' => [ 'shape' => 'RecommendationLifecycleStage', ], 'pillars' => [ 'shape' => 'RecommendationPillarList', ], 'source' => [ 'shape' => 'RecommendationSource', ], 'awsServices' => [ 'shape' => 'RecommendationAwsServiceList', ], 'name' => [ 'shape' => 'String', ], 'resourcesAggregates' => [ 'shape' => 'RecommendationResourcesAggregates', ], 'pillarSpecificAggregates' => [ 'shape' => 'RecommendationPillarSpecificAggregates', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'arn' => [ 'shape' => 'OrganizationRecommendationArn', ], ], ], 'OrganizationRecommendationSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'OrganizationRecommendationSummary', ], ], 'Recommendation' => [ 'type' => 'structure', 'required' => [ 'id', 'type', 'status', 'pillars', 'source', 'name', 'resourcesAggregates', 'arn', 'description', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'RecommendationType', ], 'checkArn' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'RecommendationStatus', ], 'lifecycleStage' => [ 'shape' => 'RecommendationLifecycleStage', ], 'pillars' => [ 'shape' => 'RecommendationPillarList', ], 'source' => [ 'shape' => 'RecommendationSource', ], 'awsServices' => [ 'shape' => 'RecommendationAwsServiceList', ], 'name' => [ 'shape' => 'String', ], 'resourcesAggregates' => [ 'shape' => 'RecommendationResourcesAggregates', ], 'pillarSpecificAggregates' => [ 'shape' => 'RecommendationPillarSpecificAggregates', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'arn' => [ 'shape' => 'AccountRecommendationArn', ], 'statusReason' => [ 'shape' => 'StatusReason', ], 'description' => [ 'shape' => 'String', ], 'createdBy' => [ 'shape' => 'String', ], 'updatedOnBehalfOf' => [ 'shape' => 'String', ], 'updatedOnBehalfOfJobTitle' => [ 'shape' => 'String', ], 'updateReason' => [ 'shape' => 'RecommendationUpdateReason', ], 'updateReasonCode' => [ 'shape' => 'UpdateRecommendationLifecycleStageReasonCode', ], 'resolvedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'RecommendationAwsService' => [ 'type' => 'string', 'max' => 30, 'min' => 2, ], 'RecommendationAwsServiceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationAwsService', ], ], 'RecommendationCostOptimizingAggregates' => [ 'type' => 'structure', 'required' => [ 'estimatedMonthlySavings', 'estimatedPercentMonthlySavings', ], 'members' => [ 'estimatedMonthlySavings' => [ 'shape' => 'Double', ], 'estimatedPercentMonthlySavings' => [ 'shape' => 'Double', ], ], ], 'RecommendationLanguage' => [ 'type' => 'string', 'enum' => [ 'en', 'ja', 'zh', 'fr', 'de', 'ko', 'zh_TW', 'it', 'es', 'pt_BR', 'id', ], ], 'RecommendationLifecycleStage' => [ 'type' => 'string', 'enum' => [ 'in_progress', 'pending_response', 'dismissed', 'resolved', ], ], 'RecommendationPillar' => [ 'type' => 'string', 'enum' => [ 'cost_optimizing', 'performance', 'security', 'service_limits', 'fault_tolerance', 'operational_excellence', ], ], 'RecommendationPillarList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationPillar', ], 'max' => 50, 'min' => 1, ], 'RecommendationPillarSpecificAggregates' => [ 'type' => 'structure', 'members' => [ 'costOptimizing' => [ 'shape' => 'RecommendationCostOptimizingAggregates', ], ], ], 'RecommendationRegionCode' => [ 'type' => 'string', 'max' => 20, 'min' => 9, ], 'RecommendationResourceArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:[\\w-]+:trustedadvisor::\\d{12}:recommendation-resource\\/[\\w-]+\\/[\\w-]+', ], 'RecommendationResourceExclusion' => [ 'type' => 'structure', 'required' => [ 'arn', 'isExcluded', ], 'members' => [ 'arn' => [ 'shape' => 'RecommendationResourceArn', ], 'isExcluded' => [ 'shape' => 'Boolean', ], ], ], 'RecommendationResourceExclusionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationResourceExclusion', ], 'max' => 25, 'min' => 1, ], 'RecommendationResourceSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'awsResourceId', 'regionCode', 'status', 'metadata', 'lastUpdatedAt', 'recommendationArn', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'arn' => [ 'shape' => 'RecommendationResourceArn', ], 'awsResourceId' => [ 'shape' => 'String', ], 'regionCode' => [ 'shape' => 'RecommendationRegionCode', ], 'status' => [ 'shape' => 'ResourceStatus', ], 'metadata' => [ 'shape' => 'StringMap', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'exclusionStatus' => [ 'shape' => 'ExclusionStatus', ], 'recommendationArn' => [ 'shape' => 'AccountRecommendationArn', ], ], ], 'RecommendationResourceSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationResourceSummary', ], ], 'RecommendationResourcesAggregates' => [ 'type' => 'structure', 'required' => [ 'okCount', 'warningCount', 'errorCount', ], 'members' => [ 'okCount' => [ 'shape' => 'Long', ], 'warningCount' => [ 'shape' => 'Long', ], 'errorCount' => [ 'shape' => 'Long', ], 'excludedCount' => [ 'shape' => 'Long', ], ], ], 'RecommendationSource' => [ 'type' => 'string', 'enum' => [ 'aws_config', 'compute_optimizer', 'cost_explorer', 'lse', 'manual', 'pse', 'rds', 'resilience', 'resilience_hub', 'security_hub', 'stir', 'ta_check', 'well_architected', 'cost_optimization_hub', ], ], 'RecommendationStatus' => [ 'type' => 'string', 'enum' => [ 'ok', 'warning', 'error', ], ], 'RecommendationSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'type', 'status', 'pillars', 'source', 'name', 'resourcesAggregates', 'arn', ], 'members' => [ 'id' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'RecommendationType', ], 'checkArn' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'RecommendationStatus', ], 'lifecycleStage' => [ 'shape' => 'RecommendationLifecycleStage', ], 'pillars' => [ 'shape' => 'RecommendationPillarList', ], 'source' => [ 'shape' => 'RecommendationSource', ], 'awsServices' => [ 'shape' => 'RecommendationAwsServiceList', ], 'name' => [ 'shape' => 'String', ], 'resourcesAggregates' => [ 'shape' => 'RecommendationResourcesAggregates', ], 'pillarSpecificAggregates' => [ 'shape' => 'RecommendationPillarSpecificAggregates', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'arn' => [ 'shape' => 'AccountRecommendationArn', ], 'statusReason' => [ 'shape' => 'StatusReason', ], ], ], 'RecommendationSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RecommendationSummary', ], ], 'RecommendationType' => [ 'type' => 'string', 'enum' => [ 'standard', 'priority', ], ], 'RecommendationUpdateReason' => [ 'type' => 'string', 'max' => 4096, 'min' => 10, 'pattern' => '[\\s\\S]*', 'sensitive' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResourceStatus' => [ 'type' => 'string', 'enum' => [ 'ok', 'warning', 'error', ], ], 'StatusReason' => [ 'type' => 'string', 'enum' => [ 'no_data_ok', ], ], 'String' => [ 'type' => 'string', ], 'StringMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => true, ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'UpdateOrganizationRecommendationLifecycleRequest' => [ 'type' => 'structure', 'required' => [ 'lifecycleStage', 'organizationRecommendationIdentifier', ], 'members' => [ 'lifecycleStage' => [ 'shape' => 'UpdateRecommendationLifecycleStage', ], 'updateReason' => [ 'shape' => 'RecommendationUpdateReason', ], 'updateReasonCode' => [ 'shape' => 'UpdateRecommendationLifecycleStageReasonCode', ], 'organizationRecommendationIdentifier' => [ 'shape' => 'OrganizationRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'organizationRecommendationIdentifier', ], ], ], 'UpdateRecommendationLifecycleRequest' => [ 'type' => 'structure', 'required' => [ 'lifecycleStage', 'recommendationIdentifier', ], 'members' => [ 'lifecycleStage' => [ 'shape' => 'UpdateRecommendationLifecycleStage', ], 'updateReason' => [ 'shape' => 'RecommendationUpdateReason', ], 'updateReasonCode' => [ 'shape' => 'UpdateRecommendationLifecycleStageReasonCode', ], 'recommendationIdentifier' => [ 'shape' => 'AccountRecommendationIdentifier', 'location' => 'uri', 'locationName' => 'recommendationIdentifier', ], ], ], 'UpdateRecommendationLifecycleStage' => [ 'type' => 'string', 'enum' => [ 'pending_response', 'in_progress', 'dismissed', 'resolved', ], ], 'UpdateRecommendationLifecycleStageReasonCode' => [ 'type' => 'string', 'enum' => [ 'non_critical_account', 'temporary_account', 'valid_business_case', 'other_methods_available', 'low_priority', 'not_applicable', 'other', ], ], 'UpdateRecommendationResourceExclusionError' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'RecommendationResourceArn', ], 'errorCode' => [ 'shape' => 'String', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'UpdateRecommendationResourceExclusionErrorList' => [ 'type' => 'list', 'member' => [ 'shape' => 'UpdateRecommendationResourceExclusionError', ], ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ],];
