# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
# Provided as AWS Content under the AWS Customer (Enterprise) Agreement

####################################
# This script manages mounting the VHD to a drive letter, folder path, or both. To use it, define a value for either $MountFolder or $MountDrive letter, or both. At least one must be specified.
#####################################

# Specify a folder path to mount to. When specified, the script will check to see if the folder exists, and is empty, before mounting. If the folder doesn't exist, the folder will be created. If the folder exists, and isn't empty, the folder mounting will fail.
$MountFolder = "C:\Path\To\Mount\Folder"

# Specify a drive letter to mount to. Specify the colon after specifying the drive letter. Note: A-E are reserved for AppStream 2.0. You will need to choose a different drive letter. 
$MountDriveLetter = "F:"

#If $PathToVHD isn't specified, the script will automatically search for the VHDX file in the same directory to mount.
$PathToVHD = ""

$ScriptFolder = $($PSScriptRoot+"\")

#Uncompresses any zipped files in the AppBlock's folder
Get-ChildItem -Path $ScriptFolder -Filter *.zip | % {Expand-Archive $_ -DestinationPath $ScriptFolder}

if($PathToVHD -eq "" ) {
    if((Get-ChildItem -Path $ScriptFolder -Filter "*.vhdx" | Group-Object -Property Extension).Count -ne 1) {
        Write-Host "Too many VHDs found, exiting"
        Break
    }
    $PathToVHD = (Get-ChildItem -Path $ScriptFolder -Filter "*.vhdx").FullName
    Write-Host "Found VHD: $($PathToVHD)" 
}

rm "$($ScriptFolder)attach1.txt" -ErrorAction Ignore
Out-File "$($ScriptFolder)attach1.txt" -InputObject "select vdisk file='$($PathToVHD)'" -Encoding utf8 -Append
Out-File "$($ScriptFolder)attach1.txt" -InputObject "attach vdisk" -Encoding utf8 -Append
Out-File "$($ScriptFolder)attach1.txt" -InputObject "rescan" -Encoding utf8 -Append
Out-File "$($ScriptFolder)attach1.txt" -InputObject "select partition 1" -Encoding utf8 -Append
Out-File "$($ScriptFolder)attach1.txt" -InputObject "remove all noerr" -Encoding utf8 -Append
#Add the folder mount point to the VHD, if necessary
if($MountFolder -ne "") {
    #Check if the folder path already exists. If not, create it
    if((Test-Path $MountFolder) -eq $false) {
        New-Item -ItemType "directory" -Path $MountFolder
    }

    #Check if the folder path is empty. If it is, add it to the mounted VHD. If not, skip.
    if ((Get-ChildItem $MountFolder | Measure-Object).Count -eq 0) {
        Out-File "$($ScriptFolder)attach1.txt" -InputObject "assign mount='$($MountFolder)'" -Encoding utf8 -Append    
    } else {
        Write-Host "Folder not empty, skipping adding mount"
    }
    
}

#Add the drive letter to the VHD, if necessary
if($MountDriveLetter -ne "") {
    #Check if the drive letter already exists. If it doesn't, add it to the mounted VHD. If it does, skip.
    if((Test-Path $MountDriveLetter) -eq $false) {
        Out-File "$($ScriptFolder)attach1.txt" -InputObject "assign mount='$($MountDriveLetter)'" -Encoding utf8 -Append
    } else {
        Write-Host "Drive letter already exists, skipping adding mount"
    }
}

Out-File "$($ScriptFolder)attach1.txt" -InputObject "exit" -Encoding utf8 -Append
Write-Host "Execute: diskpart /s '$($ScriptFolder)attach1.txt'"
diskpart /s "$($ScriptFolder)attach1.txt"
